package com.clx.performance.vo.pc.breakcontract.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageCarrierBreakContractSettlementOwnerDetailVO {

    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @ApiModelProperty("违约方类型Msg：1平台 2货主 3车主")
    private String breakContractPartyTypeMsg;

    @ApiModelProperty("违约单号")
    private String breakNo;

    @ApiModelProperty("结算单号")
    private String settlementNo;

    @ApiModelProperty("货主用户编号")
    private Long ownerUserNo;

    @ApiModelProperty("货主名称")
    private String ownerName;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @MoneyOutConvert
    @ApiModelProperty("违约金")
    private BigDecimal figure;

    @ApiModelProperty("违约说明")
    private String breakContractRemark;

    @ApiModelProperty("操作人名称")
    private String createName;

    @ApiModelProperty("创建时间")
    private String createTime;


}