package com.clx.performance.vo.feign;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @Description
 * @Author aiqingguo
 * @Date 2023-10-19 16:33:52
 * @Version 1.0
 */
@Getter
@Setter
public class OwnerInfoVO {

    @ApiModelProperty("用户编号")
    private Long userNo;
    
    @ApiModelProperty("姓名")
    private String name;
    
    @ApiModelProperty("手机号码")
    private String mobile;
    
    @ApiModelProperty("货主类型  1企业  2个人")
    private Integer ownerType;

    @ApiModelProperty("所属银行")
    private String ownerAccountBank;

    @ApiModelProperty("开户行")
    private String ownerOpenBank;

    @ApiModelProperty("开户行号")
    private String ownerOpenBankNumber;

    @ApiModelProperty("户名")
    private String ownerAccountName;

    @ApiModelProperty("银行账户")
    private String ownerBankAccount;

    @ApiModelProperty("结算账期  1拉运完成结  2月结")
    private Integer settlementAccountPeriod;

    @ApiModelProperty("结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;

    @ApiModelProperty("冻结方式  1自动冻结 2手动冻结")
    private Integer freezeSetting;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("法人姓名")
    private String legalName;

    @ApiModelProperty("法人身份证")
    private String legalCardNo;
    @ApiModelProperty(value = "法人手机号", example = "")
    private String legalMobile;
    @ApiModelProperty("营业执照图片地址")
    private String companyBusinessImg;

    @ApiModelProperty("营业执照编号")
    private String companyBusinessNo;


    @ApiModelProperty("公司税号")
    private String companyTaxCode;

    @ApiModelProperty("公司地址")
    private String companyAddress;

    @ApiModelProperty("公司联系电话")
    private String companyTelephone;

    @ApiModelProperty("公司银行账户")
    private String companyBankAccount;

    @ApiModelProperty("公司开户行")
    private String companyOpenBank;

    @ApiModelProperty("统一社会信用代码")
    private String companyGroupCode;

    @ApiModelProperty("联系人")
    private String contactsName;
    @ApiModelProperty("联系电话")
    private String contactsTelephone;
    @ApiModelProperty("联系地址")
    private String contactsAddress;
    @ApiModelProperty("网络货运货主编码")
    private String transportOwnerCode;

    @ApiModelProperty("创建时间")
    private String createTime;

}
