package com.clx.performance.vo.app;

import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Objects;

import static com.clx.performance.enums.PerformanceResultEnum.ORDER_CHILD_LOAD_LIMIT_CONFIG_DISABLED;

/**
 * 是否需要监装结果VO
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class OrderChildLoadRangeCheckResultVO {

    @ApiModelProperty(value = "是否需要弹信息 0 不需要 1 需要", example = "0")
    private Integer needAlert;
    @ApiModelProperty(value = "错误码", example = "-1")
    private Integer code;
    @ApiModelProperty(value = "错误信息", example = "错误")
    private String msg;

    public Result<OrderChildLoadRangeCheckResultVO> toResult() {
        if (Objects.equals(code, OrderChildEnum.NeedAlertEnum.OK.getCode())
                //配置禁用也不弹窗
                || (Objects.equals(code, ORDER_CHILD_LOAD_LIMIT_CONFIG_DISABLED.getCode()))
        ) {
            return Result.ok();
        } else {
            Result<OrderChildLoadRangeCheckResultVO> result = Result.fail(PerformanceResultEnum.getEnumByCode(code));
            result.setData(this);
            result.setMsg(msg);
            return result;
        }
    }

}