package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotNull;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class PageOrderGoodsListParam extends PageParam {

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "货单编号")
    private String orderGoodsNo;

    @ApiModelProperty(value = "货单状态： 10：已挂单  20：挂单中 30：运输中 40：已完成 50：已取消 60:已完结")
    private Integer orderGoodsStatus;

    @ApiModelProperty(value = "开始时间", example = "2023-09-09 12:00:01")
    private String beginTime;

    @ApiModelProperty(value = "结束时间", example = "2023-09-09 12:00:01")
    private String endTime;

    @ApiModelProperty(value = "用车类型： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;

    @ApiModelProperty(value="发货地址",example = "北京")
    private String sendAddress;

    @ApiModelProperty(value="收货地址",example = "黄羊城")
    private String receiveAddress;


}
