package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildLoadParam extends PositionParam {

    @ApiModelProperty(value = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "装货毛重（单位吨）", example = "2.46")
    @NotNull
    private BigDecimal loadRough;

    @ApiModelProperty(value = "装货皮重（单位吨）", example = "1.23")
    @NotNull
    private BigDecimal loadTare;

    @ApiModelProperty(value = "磅单图片列表")
    @NotEmpty(message = "请上传磅单照片")
    private List<String> loadImageList;

    @ApiModelProperty(value = "装货时间")
    private String loadTime;
}
