package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum OwnerLoanAccountApproveEnum {
    ;

    //“待审批 10，审批成功 20，审批拒绝 30
    @Getter
    @AllArgsConstructor
    public enum Status {
        APPROVE_WAIT(10, "待审批"),
        APPROVE_PASS(20, "审批通过"),
        APPROVE_REFUSE(30, "审批拒绝"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerLoanAccountApproveEnum.Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(OwnerLoanAccountApproveEnum.Status::getMsg).orElse(null);
        }
    }

}
