package com.clx.performance.enums;

import com.msl.common.enums.ResultEnum;

/**
 * Created by wangjianxin on 2017/5/2.
 * 7001-7799 业务错误结果
 * 7801-7999 系统错误结果
 */
public enum TraceServiceResultEnum implements ResultEnum {
    CHILD_NO_CANNOT_NULL(7001, "子订单号不能为空"),
    POINT_LIST_CANNOT_NULL(7002, "记录点不能为空"),

    TRUCK_LOCATION_QUERY_ERROR(7003, "车辆位置查询失败"),
    ZJXL_TOKEN_INVALID(7003, "中交兴路token失效"),
            ;
    private String msg;
    private Integer code;

    @Override
    public String getMsg() {
        return msg;
    }

    @Override
    public int getCode() {
        return code;
    }

    private TraceServiceResultEnum(Integer code, String msg) {
        this.msg = msg;
        this.code = code;
    }

}
