package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
//"车辆燃料类型 1：柴油 2 天然气 3其他 4新能源/电"
public enum PowerTypeEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {

        DIESEL_OIL(1, "柴油"),
        NATURAL_GAS(2, "天然气"),
        OTHER(3, "其他"),
        NEW_ENERGY(4, "新能源/电"),

        ;

        private final Integer code;
        private final String name;

        public static Optional<Type> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static Optional<Type> getByName(String name) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getName(), name)).findFirst();
        }

        public static Integer getCodeByName(String name) {
            return getByName(name).map(PowerTypeEnum.Type::getCode).orElse(3);
        }
    }


}
