package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderChildSyncTransportRecordEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        INIT(0, "未同步"),
        SYNC(1, "已同步"),
        SUC(2, "回调成功"),
        FAIL(3, "回调失败"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

}
