/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.nbcb.bouncycastle.util.encoders.Base64;
import com.nbcb.callback.CommonSecurityServiceMerchant;
import com.nbcb.sdk.AbstractBussinessBean;
import com.nbcb.sdk.SDKRequestHead;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.aes.param.ConfigParam;
import com.nbcb.sdk.aes.param.HeaderConfig;
import com.nbcb.sdk.aes.param.KeyStoreFactory;
import com.nbcb.sdk.aes.param.Version;
import com.nbcb.sdk.aes.service.ApproveDevService;
import com.nbcb.sdk.aes.service.BuildErrorRespService;
import com.nbcb.sdk.aes.service.BussinessAdapterService;
import com.nbcb.sdk.aes.service.CheckTokenService;
import com.nbcb.sdk.aes.service.CommonSecurityService;
import com.nbcb.sdk.aes.service.CoverHeadService;
import com.nbcb.sdk.aes.service.FieldCheckoutService;
import com.nbcb.sdk.aes.service.OpenFileService;
import com.nbcb.sdk.aes.service.PackHeadService;
import com.nbcb.sdk.aes.utils.FileUtils;
import com.nbcb.sdk.aes.utils.RandomKey;
import com.nbcb.sdk.file.FileDownloadResponse;
import com.nbcb.sdk.file.FileUploadRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OpenSDK {
    private static final Log log = LogFactory.getLog(OpenSDK.class);
    private static Boolean isInit = false;

    public static boolean init(InputStream stream, String privatekey) {
        return OpenSDK.initLocal(stream, privatekey);
    }

    public static boolean init(String path, String privatekey) {
        return OpenSDK.initLocal(path, privatekey);
    }

    public static void dynamicInit(ConfigParam configParam, boolean coverFlag) throws SDKException {
        ConfigFile.addConfig(configParam, coverFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean initLocal(Object path, String privatekey) {
        if (!isInit.booleanValue()) {
            Boolean bl = isInit;
            synchronized (bl) {
                try {
                    if (path instanceof InputStream) {
                        InputStream localStream = (InputStream)path;
                        ConfigFile.readConfig(localStream, privatekey);
                    } else {
                        String localPath = (String)path;
                        ConfigFile.readConfig(localPath, privatekey);
                    }
                    ConfigFile.PRIVATEKEY = privatekey;
                    KeyStoreFactory.getInstance();
                    isInit = isInit == false;
                    TypeUtils.compatibleWithJavaBean = true;
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
                    }
                    return false;
                }
                log.info((Object)"\u521d\u59cb\u5316\u6210\u529f...");
            }
        }
        return isInit;
    }

    public static Map<String, Object> approveDev() throws SDKException {
        try {
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByBean(null, "");
            byte[] cntrKey = RandomKey.getKey(16);
            byte[] syncKey = RandomKey.getKey(16);
            byte[] reqJson = ApproveDevService.encry(head, randomKey, cntrKey, syncKey);
            byte[] resp = BussinessAdapterService.post("approveDev", reqJson, head);
            ApproveDevService.decry(resp, randomKey, cntrKey, syncKey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u5f00\u53d1\u8005\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
            }
            throw new SDKException(SDKExceptionEnums.APPROVEDEV_FAIL);
        }
        return KeyStoreFactory.getInstance().getTokenMap();
    }

    public static Map<String, Object> approveDev(String appkey) throws SDKException {
        try {
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByBean(appkey, null, "");
            byte[] cntrKey = RandomKey.getKey(16);
            byte[] syncKey = RandomKey.getKey(16);
            byte[] reqJson = ApproveDevService.encry(appkey, head, randomKey, cntrKey, syncKey);
            byte[] resp = BussinessAdapterService.post(appkey, "approveDev", reqJson, head);
            ApproveDevService.decry(appkey, resp, randomKey, cntrKey, syncKey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u5f00\u53d1\u8005\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
            }
            throw new SDKException(SDKExceptionEnums.APPROVEDEV_FAIL);
        }
        return ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getTokenMap();
    }

    public static int send(AbstractBussinessBean bean) throws Exception {
        ParserConfig.getGlobalInstance().setAsmEnable(false);
        int returnStatus = 0;
        try {
            String token;
            Map<String, Object> localMap = KeyStoreFactory.getInstance().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev();
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
                return 1;
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            FieldCheckoutService.check(bean);
            SDKRequestHead head = PackHeadService.packReqHeadByBean(bean, token);
            byte[] randomKey = RandomKey.getKey(16);
            byte[] reqJson = CommonSecurityService.encryService(bean, head, randomKey, cntrKey, syncKey);
            byte[] resp = BussinessAdapterService.post(bean.getUrl(), reqJson, head);
            boolean dev = CommonSecurityService.decryService(bean, resp, randomKey, cntrKey);
            CheckTokenService.CheckToken(bean);
        }
        catch (Exception e) {
            returnStatus = 1;
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            }
            if (e instanceof SDKException) {
                BuildErrorRespService.buildErrorResp((SDKException)e, bean);
            }
            throw e;
        }
        return returnStatus;
    }

    public static String send(String productID, String serviceID, String json) throws Exception {
        String respValue = "";
        try {
            String token;
            Map<String, Object> localMap = KeyStoreFactory.getInstance().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev();
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                return BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByJson(productID, json, token);
            json = CoverHeadService.cover(head, json);
            byte[] reqJson = CommonSecurityService.encryService(json, randomKey, cntrKey, syncKey);
            byte[] resp = null;
            log.info((Object)("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587\uff1a" + new String(reqJson, "UTF-8")));
            resp = productID == null || "".equals(productID) ? BussinessAdapterService.post(serviceID, reqJson, head) : BussinessAdapterService.post(productID + "/" + serviceID, reqJson, head);
            log.info((Object)("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587\uff1a" + new String(resp, "UTF-8")));
            String respStr = new String(resp, "UTF-8");
            if (!ApproveDevService.IsCliperText(respStr)) {
                return respStr;
            }
            if (OpenSDK.containsRetCode(respStr)) {
                return respStr;
            }
            Map<String, Object> decryMap = CommonSecurityService.decryService(resp, randomKey, cntrKey);
            respValue = (String)decryMap.get("respValue");
            boolean dev = (Boolean)decryMap.get("dev");
            CheckTokenService.refreshToken(dev);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            }
            if (e instanceof SDKException) {
                respValue = BuildErrorRespService.buildErrorResp((SDKException)e);
            }
            throw e;
        }
        return respValue;
    }

    public static String send(String appkey, String productID, String serviceID, String json) throws Exception {
        String respValue = "";
        try {
            String token;
            Map<String, Object> localMap = ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev(appkey);
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                return BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByJson(appkey, productID, json, token);
            json = CoverHeadService.cover(head, json);
            byte[] reqJson = CommonSecurityService.encryService(json, randomKey, cntrKey, syncKey);
            byte[] resp = null;
            JSONObject openHeader = ConfigFile.configMap.get(appkey).getOPEN_HEADER();
            JSONObject headerMap = new HashMap();
            if (openHeader != null) {
                headerMap = openHeader;
            }
            log.info((Object)("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587\uff1a" + new String(reqJson, "UTF-8")));
            resp = productID == null || "".equals(productID) ? BussinessAdapterService.post(appkey, serviceID, reqJson, head, (Map<String, String>)headerMap) : BussinessAdapterService.post(appkey, productID + "/" + serviceID, reqJson, head, (Map<String, String>)headerMap);
            log.info((Object)("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587\uff1a" + new String(resp, "UTF-8")));
            String respStr = new String(resp, "UTF-8");
            if (!ApproveDevService.IsCliperText(respStr)) {
                return respStr;
            }
            if (OpenSDK.containsRetCode(respStr)) {
                return respStr;
            }
            Map<String, Object> decryMap = CommonSecurityService.decryService(resp, randomKey, cntrKey);
            respValue = (String)decryMap.get("respValue");
            boolean dev = (Boolean)decryMap.get("dev");
            CheckTokenService.refreshToken(dev, appkey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            }
            if (e instanceof SDKException) {
                respValue = BuildErrorRespService.buildErrorResp((SDKException)e);
            }
            throw e;
        }
        return respValue;
    }

    public static String send(String appkey, String productID, String serviceID, String json, HeaderConfig headerConfig) throws Exception {
        String respValue = "";
        try {
            String token;
            Map<String, Object> localMap = ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev(appkey);
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                return BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByJson(appkey, productID, json, token);
            json = CoverHeadService.cover(head, json);
            byte[] reqJson = CommonSecurityService.encryService(json, randomKey, cntrKey, syncKey);
            byte[] resp = null;
            HashMap<String, String> headerMap = new HashMap();
            Map<String, String> httpHeader = headerConfig.getHeader();
            if (appkey.equals(httpHeader.get("APP_KEY"))) {
                headerMap = httpHeader;
            }
            log.info((Object)("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587\uff1a" + new String(reqJson, "UTF-8")));
            resp = productID == null || "".equals(productID) ? BussinessAdapterService.post(appkey, serviceID, reqJson, head, headerMap) : BussinessAdapterService.post(appkey, productID + "/" + serviceID, reqJson, head, headerMap);
            log.info((Object)("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587\uff1a" + new String(resp, "UTF-8")));
            String respStr = new String(resp, "UTF-8");
            if (!ApproveDevService.IsCliperText(respStr)) {
                return respStr;
            }
            if (OpenSDK.containsRetCode(respStr)) {
                return respStr;
            }
            Map<String, Object> decryMap = CommonSecurityService.decryService(resp, randomKey, cntrKey);
            respValue = (String)decryMap.get("respValue");
            boolean dev = (Boolean)decryMap.get("dev");
            CheckTokenService.refreshToken(dev, appkey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            }
            if (e instanceof SDKException) {
                respValue = BuildErrorRespService.buildErrorResp((SDKException)e);
            }
            throw e;
        }
        return respValue;
    }

    public static String sendFile(String productID, String channelNo, String filename, byte ... bytes) throws Exception {
        return OpenSDK.send(productID, "fileUpload", JSON.toJSONString(OpenSDK.getFileUploadRequest(channelNo, filename, bytes)));
    }

    public static String sendFile(String appKey, String productID, String channelNo, String filename, byte ... bytes) throws Exception {
        return OpenSDK.send(appKey, productID, "fileUpload", JSON.toJSONString(OpenSDK.getFileUploadRequest(channelNo, filename, bytes)));
    }

    public static String sendFile(String appKey, String productID, HeaderConfig headerConfig, String channelNo, String filename, byte ... bytes) throws Exception {
        return OpenSDK.send(appKey, productID, "fileUpload", JSON.toJSONString(OpenSDK.getFileUploadRequest(channelNo, filename, bytes)), headerConfig);
    }

    public static FileDownloadResponse sendFileDownload(String productID, String channelNo, String fileId, String dirPath) throws Exception {
        String res = OpenSDK.send(productID, "fileDownload", OpenSDK.getFileDownloadRequest(fileId, channelNo));
        return OpenSDK.handleFileDowloadRes(fileId, dirPath, res);
    }

    public static FileDownloadResponse sendFileDownload(String appKey, String productID, String channelNo, String fileId, String dirPath) throws Exception {
        String res = OpenSDK.send(appKey, productID, "fileDownload", OpenSDK.getFileDownloadRequest(fileId, channelNo));
        return OpenSDK.handleFileDowloadRes(fileId, dirPath, res);
    }

    public static FileDownloadResponse sendFileDownload(String appKey, String productID, String channelNo, HeaderConfig headerConfig, String fileId, String dirPath) throws Exception {
        String res = OpenSDK.send(appKey, productID, "fileDownload", OpenSDK.getFileDownloadRequest(fileId, channelNo), headerConfig);
        return OpenSDK.handleFileDowloadRes(fileId, dirPath, res);
    }

    public static String sendBigFile(String appkey, String channelNo, String filePath) throws Exception {
        return OpenFileService.sendBigFile(appkey, channelNo, filePath);
    }

    public static String sendBigFile(String channelNo, String filePath) throws Exception {
        return OpenFileService.sendBigFile(channelNo, filePath);
    }

    public static String sendBigFileDownload(String appkey, String channelNo, String fileId, String dirPath) throws Exception {
        return OpenFileService.sendBigFileDownload(appkey, channelNo, fileId, dirPath);
    }

    public static String sendBigFileDownload(String channelNo, String fileId, String dirPath) throws Exception {
        return OpenFileService.sendBigFileDownload(channelNo, fileId, dirPath);
    }

    public static FileDownloadResponse handleFileDowloadRes(String fileId, String dirPath, String res) throws Exception {
        JSONObject resJson = JSONObject.parseObject((String)res);
        FileDownloadResponse fileDownloadResponse = (FileDownloadResponse)JSONObject.parseObject((String)JSON.toJSONString((Object)resJson.getJSONObject("Data")), FileDownloadResponse.class);
        if (!"0000".equals(fileDownloadResponse.getRetCode())) {
            return fileDownloadResponse;
        }
        if (dirPath == null) {
            return fileDownloadResponse;
        }
        String originalFilename = fileDownloadResponse.getData().getOriginalFilename();
        String suffix = originalFilename.substring(originalFilename.indexOf("."), originalFilename.length());
        File dirFile = new File(dirPath);
        if (dirFile.isFile()) {
            throw new RuntimeException("dirPath\u5fc5\u987b\u4e3a\u76ee\u5f55");
        }
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        String localFilePath = dirPath + File.separator + originalFilename;
        FileUtils.copy(Base64.decode(fileDownloadResponse.getData().getFileBytes()), new File(localFilePath));
        return fileDownloadResponse;
    }

    public static String getFileDownloadRequest(String fileId, String channelNo) {
        HashMap requestMap = new HashMap();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        requestMap.put("Data", dataMap);
        dataMap.put("fileId", fileId);
        dataMap.put("channelNo", channelNo);
        return JSON.toJSONString(requestMap);
    }

    private static void checkFilename(String filename) {
        if (null == filename || !filename.contains(".")) {
            throw new IllegalArgumentException("filename \u4e0d\u5408\u6cd5;");
        }
    }

    private static Map<String, FileUploadRequest> getFileUploadRequest(String channelNo, String filename, byte ... bytes) throws Exception {
        OpenSDK.checkFilename(filename);
        if (channelNo == null || channelNo.trim().length() == 0) {
            throw new IllegalArgumentException("channelNo \u4e0d\u5408\u6cd5;");
        }
        if (null == bytes || bytes.length <= 0) {
            File file = new File(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.format("%s \u6587\u4ef6\u4e0d\u5b58\u5728", filename));
            }
            bytes = OpenSDK.readAllBytes(file);
            int index = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            index = index >= 0 ? index + 1 : 0;
            filename = filename.substring(index);
        }
        HashMap<String, FileUploadRequest> map = new HashMap<String, FileUploadRequest>();
        map.put("Data", FileUploadRequest.builder().bytes(Base64.toBase64String(bytes)).filename(filename).channelNo(channelNo).build());
        return map;
    }

    private static byte[] readAllBytes(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[1024000];
            while ((length = fileInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            byte[] data = byteArrayOutputStream.toByteArray();
            fileInputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362\u6210\u5b57\u8282\u6570\u7ec4\u51fa\u9519");
        }
        finally {
            fileInputStream.close();
            byteArrayOutputStream.close();
        }
    }

    public static String encryptMessage(String data) throws SDKException {
        byte[] randomKey = RandomKey.getKey(16);
        String returnMessage = "";
        try {
            byte[] reqJson = CommonSecurityServiceMerchant.encryService(data, randomKey);
            returnMessage = new String(reqJson, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return returnMessage;
    }

    public static String decryptMessage(String data) throws Exception {
        byte[] dataByte = data.getBytes("UTF-8");
        String respValue = "";
        respValue = CommonSecurityServiceMerchant.decryService(dataByte);
        return respValue;
    }

    public static String encryptMessageForMultiCustomer(String appkey, String data) throws SDKException {
        byte[] randomKey = RandomKey.getKey(16);
        String returnMessage = "";
        try {
            byte[] reqJson = CommonSecurityServiceMerchant.encryService(appkey, data, randomKey);
            returnMessage = new String(reqJson, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return returnMessage;
    }

    public static String decryptMessageForMultiCustomer(String appkey, String data) throws Exception {
        byte[] dataByte = data.getBytes("UTF-8");
        String respValue = "";
        respValue = CommonSecurityServiceMerchant.decryService(appkey, dataByte);
        return respValue;
    }

    public static String getVersionInfo() {
        JSONObject versionInfo = new JSONObject(true);
        try {
            String[] updateInfo = Version.UPDATE_INFO;
            versionInfo.put("SDK\u7248\u672c", (Object)"2.1.230630");
            JSONObject updateInfoObj = new JSONObject(true);
            for (int i = 0; i < updateInfo.length; ++i) {
                updateInfoObj.put(i + 1 + "", (Object)updateInfo[i]);
            }
            versionInfo.put("SDK\u66f4\u65b0\u5185\u5bb9", (Object)updateInfoObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return versionInfo.toJSONString();
    }

    public static boolean containsRetCode(String respStr) {
        return respStr == null || respStr.contains("OPENRetCode");
    }

    public static String objToStr(Object obj) {
        String value = "";
        if (null != obj) {
            return obj.toString();
        }
        return value;
    }
}

