/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.jcajce.provider.newhope;

import com.nbcb.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.nbcb.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.nbcb.bouncycastle.crypto.CipherParameters;
import com.nbcb.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.nbcb.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.nbcb.bouncycastle.pqc.jcajce.interfaces.NHPublicKey;
import com.nbcb.bouncycastle.util.Arrays;
import java.io.IOException;

public class BCNHPublicKey
implements NHPublicKey {
    private static final long serialVersionUID = 1L;
    private final NHPublicKeyParameters params;

    public BCNHPublicKey(NHPublicKeyParameters params) {
        this.params = params;
    }

    public BCNHPublicKey(SubjectPublicKeyInfo keyInfo) {
        this.params = new NHPublicKeyParameters(keyInfo.getPublicKeyData().getBytes());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BCNHPublicKey)) {
            return false;
        }
        BCNHPublicKey otherKey = (BCNHPublicKey)o;
        return Arrays.areEqual(this.params.getPubData(), otherKey.params.getPubData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getPubData());
    }

    @Override
    public final String getAlgorithm() {
        return "NH";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(algorithmIdentifier, this.params.getPubData());
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getPublicData() {
        return this.params.getPubData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }
}

