/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.jcajce.provider.newhope;

import com.nbcb.bouncycastle.asn1.ASN1OctetString;
import com.nbcb.bouncycastle.asn1.DEROctetString;
import com.nbcb.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.nbcb.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.nbcb.bouncycastle.crypto.CipherParameters;
import com.nbcb.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.nbcb.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.nbcb.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import com.nbcb.bouncycastle.util.Arrays;
import com.nbcb.bouncycastle.util.Pack;
import java.io.IOException;

public class BCNHPrivateKey
implements NHPrivateKey {
    private static final long serialVersionUID = 1L;
    private final NHPrivateKeyParameters params;

    public BCNHPrivateKey(NHPrivateKeyParameters params) {
        this.params = params;
    }

    public BCNHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.params = new NHPrivateKeyParameters(BCNHPrivateKey.convert(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets()));
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey otherKey = (BCNHPrivateKey)o;
        return Arrays.areEqual(this.params.getSecData(), otherKey.params.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getSecData());
    }

    @Override
    public final String getAlgorithm() {
        return "NH";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] privateKeyData = this.params.getSecData();
            byte[] octets = new byte[privateKeyData.length * 2];
            for (int i = 0; i != privateKeyData.length; ++i) {
                Pack.shortToLittleEndian(privateKeyData[i], octets, i * 2);
            }
            PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(octets));
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public short[] getSecretData() {
        return this.params.getSecData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private static short[] convert(byte[] octets) {
        short[] rv = new short[octets.length / 2];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = Pack.littleEndianToShort(octets, i * 2);
        }
        return rv;
    }
}

