/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.crypto.xmss;

import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.nbcb.bouncycastle.crypto.KeyGenerationParameters;
import com.nbcb.bouncycastle.pqc.crypto.xmss.BDS;
import com.nbcb.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.nbcb.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.nbcb.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.nbcb.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.nbcb.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.nbcb.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import java.security.SecureRandom;

public final class XMSSKeyPairGenerator {
    private XMSSParameters params;
    private SecureRandom prng;

    public void init(KeyGenerationParameters param) {
        XMSSKeyGenerationParameters parameters = (XMSSKeyGenerationParameters)param;
        this.prng = parameters.getRandom();
        this.params = parameters.getParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSPrivateKeyParameters privateKey = this.generatePrivateKey(this.params, this.prng);
        XMSSNode root = privateKey.getBDSState().getRoot();
        privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withSecretKeySeed(privateKey.getSecretKeySeed()).withSecretKeyPRF(privateKey.getSecretKeyPRF()).withPublicSeed(privateKey.getPublicSeed()).withRoot(root.getValue()).withBDSState(privateKey.getBDSState()).build();
        XMSSPublicKeyParameters publicKey = new XMSSPublicKeyParameters.Builder(this.params).withRoot(root.getValue()).withPublicSeed(privateKey.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }

    private XMSSPrivateKeyParameters generatePrivateKey(XMSSParameters params, SecureRandom prng) {
        int n = params.getDigestSize();
        byte[] secretKeySeed = new byte[n];
        prng.nextBytes(secretKeySeed);
        byte[] secretKeyPRF = new byte[n];
        prng.nextBytes(secretKeyPRF);
        byte[] publicSeed = new byte[n];
        prng.nextBytes(publicSeed);
        XMSSPrivateKeyParameters privateKey = new XMSSPrivateKeyParameters.Builder(params).withSecretKeySeed(secretKeySeed).withSecretKeyPRF(secretKeyPRF).withPublicSeed(publicSeed).withBDSState(new BDS(params, publicSeed, secretKeySeed, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        return privateKey;
    }
}

