/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.crypto.rainbow;

import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.nbcb.bouncycastle.crypto.CryptoServicesRegistrar;
import com.nbcb.bouncycastle.crypto.KeyGenerationParameters;
import com.nbcb.bouncycastle.pqc.crypto.rainbow.Layer;
import com.nbcb.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import com.nbcb.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.nbcb.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.nbcb.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.nbcb.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import com.nbcb.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import java.security.SecureRandom;

public class RainbowKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private boolean initialized = false;
    private SecureRandom sr;
    private RainbowKeyGenerationParameters rainbowParams;
    private short[][] A1;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2;
    private short[][] A2inv;
    private short[] b2;
    private int numOfLayers;
    private Layer[] layers;
    private int[] vi;
    private short[][] pub_quadratic;
    private short[][] pub_singular;
    private short[] pub_scalar;

    public AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        this.keygen();
        RainbowPrivateKeyParameters privKey = new RainbowPrivateKeyParameters(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        RainbowPublicKeyParameters pubKey = new RainbowPublicKeyParameters(this.vi[this.vi.length - 1] - this.vi[0], this.pub_quadratic, this.pub_singular, this.pub_scalar);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public void initialize(KeyGenerationParameters param) {
        this.rainbowParams = (RainbowKeyGenerationParameters)param;
        this.sr = this.rainbowParams.getRandom();
        this.vi = this.rainbowParams.getParameters().getVi();
        this.numOfLayers = this.rainbowParams.getParameters().getNumOfLayers();
        this.initialized = true;
    }

    private void initializeDefault() {
        RainbowKeyGenerationParameters rbKGParams = new RainbowKeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new RainbowParameters());
        this.initialize(rbKGParams);
    }

    private void keygen() {
        this.generateL1();
        this.generateL2();
        this.generateF();
        this.computePublicKey();
    }

    private void generateL1() {
        int i;
        int dim = this.vi[this.vi.length - 1] - this.vi[0];
        this.A1 = new short[dim][dim];
        this.A1inv = null;
        ComputeInField c = new ComputeInField();
        while (this.A1inv == null) {
            for (i = 0; i < dim; ++i) {
                for (int j = 0; j < dim; ++j) {
                    this.A1[i][j] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A1inv = c.inverse(this.A1);
        }
        this.b1 = new short[dim];
        for (i = 0; i < dim; ++i) {
            this.b1[i] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateL2() {
        int i;
        int dim = this.vi[this.vi.length - 1];
        this.A2 = new short[dim][dim];
        this.A2inv = null;
        ComputeInField c = new ComputeInField();
        while (this.A2inv == null) {
            for (i = 0; i < dim; ++i) {
                for (int j = 0; j < dim; ++j) {
                    this.A2[i][j] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A2inv = c.inverse(this.A2);
        }
        this.b2 = new short[dim];
        for (i = 0; i < dim; ++i) {
            this.b2[i] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateF() {
        this.layers = new Layer[this.numOfLayers];
        for (int i = 0; i < this.numOfLayers; ++i) {
            this.layers[i] = new Layer(this.vi[i], this.vi[i + 1], this.sr);
        }
    }

    private void computePublicKey() {
        ComputeInField c = new ComputeInField();
        int rows = this.vi[this.vi.length - 1] - this.vi[0];
        int vars = this.vi[this.vi.length - 1];
        short[][][] coeff_quadratic_3dim = new short[rows][vars][vars];
        this.pub_singular = new short[rows][vars];
        this.pub_scalar = new short[rows];
        int oils = 0;
        int vins = 0;
        int crnt_row = 0;
        short[] vect_tmp = new short[vars];
        short sclr_tmp = 0;
        for (int l = 0; l < this.layers.length; ++l) {
            short[][][] coeff_alpha = this.layers[l].getCoeffAlpha();
            short[][][] coeff_beta = this.layers[l].getCoeffBeta();
            short[][] coeff_gamma = this.layers[l].getCoeffGamma();
            short[] coeff_eta = this.layers[l].getCoeffEta();
            oils = coeff_alpha[0].length;
            vins = coeff_beta[0].length;
            for (int p = 0; p < oils; ++p) {
                int x2;
                int x1;
                for (x1 = 0; x1 < oils; ++x1) {
                    for (x2 = 0; x2 < vins; ++x2) {
                        vect_tmp = c.multVect(coeff_alpha[p][x1][x2], this.A2[x1 + vins]);
                        coeff_quadratic_3dim[crnt_row + p] = c.addSquareMatrix(coeff_quadratic_3dim[crnt_row + p], c.multVects(vect_tmp, this.A2[x2]));
                        vect_tmp = c.multVect(this.b2[x2], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        vect_tmp = c.multVect(coeff_alpha[p][x1][x2], this.A2[x2]);
                        vect_tmp = c.multVect(this.b2[x1 + vins], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        sclr_tmp = GF2Field.multElem(coeff_alpha[p][x1][x2], this.b2[x1 + vins]);
                        this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], GF2Field.multElem(sclr_tmp, this.b2[x2]));
                    }
                }
                for (x1 = 0; x1 < vins; ++x1) {
                    for (x2 = 0; x2 < vins; ++x2) {
                        vect_tmp = c.multVect(coeff_beta[p][x1][x2], this.A2[x1]);
                        coeff_quadratic_3dim[crnt_row + p] = c.addSquareMatrix(coeff_quadratic_3dim[crnt_row + p], c.multVects(vect_tmp, this.A2[x2]));
                        vect_tmp = c.multVect(this.b2[x2], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        vect_tmp = c.multVect(coeff_beta[p][x1][x2], this.A2[x2]);
                        vect_tmp = c.multVect(this.b2[x1], vect_tmp);
                        this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                        sclr_tmp = GF2Field.multElem(coeff_beta[p][x1][x2], this.b2[x1]);
                        this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], GF2Field.multElem(sclr_tmp, this.b2[x2]));
                    }
                }
                for (int n = 0; n < vins + oils; ++n) {
                    vect_tmp = c.multVect(coeff_gamma[p][n], this.A2[n]);
                    this.pub_singular[crnt_row + p] = c.addVect(vect_tmp, this.pub_singular[crnt_row + p]);
                    this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], GF2Field.multElem(coeff_gamma[p][n], this.b2[n]));
                }
                this.pub_scalar[crnt_row + p] = GF2Field.addElem(this.pub_scalar[crnt_row + p], coeff_eta[p]);
            }
            crnt_row += oils;
        }
        short[][][] tmp_c_quad = new short[rows][vars][vars];
        short[][] tmp_c_sing = new short[rows][vars];
        short[] tmp_c_scal = new short[rows];
        for (int r = 0; r < rows; ++r) {
            for (int q = 0; q < this.A1.length; ++q) {
                tmp_c_quad[r] = c.addSquareMatrix(tmp_c_quad[r], c.multMatrix(this.A1[r][q], coeff_quadratic_3dim[q]));
                tmp_c_sing[r] = c.addVect(tmp_c_sing[r], c.multVect(this.A1[r][q], this.pub_singular[q]));
                tmp_c_scal[r] = GF2Field.addElem(tmp_c_scal[r], GF2Field.multElem(this.A1[r][q], this.pub_scalar[q]));
            }
            tmp_c_scal[r] = GF2Field.addElem(tmp_c_scal[r], this.b1[r]);
        }
        coeff_quadratic_3dim = tmp_c_quad;
        this.pub_singular = tmp_c_sing;
        this.pub_scalar = tmp_c_scal;
        this.compactPublicKey(coeff_quadratic_3dim);
    }

    private void compactPublicKey(short[][][] coeff_quadratic_to_compact) {
        int polynomials = coeff_quadratic_to_compact.length;
        int n = coeff_quadratic_to_compact[0].length;
        int entries = n * (n + 1) / 2;
        this.pub_quadratic = new short[polynomials][entries];
        int offset = 0;
        for (int p = 0; p < polynomials; ++p) {
            offset = 0;
            for (int x = 0; x < n; ++x) {
                for (int y = x; y < n; ++y) {
                    this.pub_quadratic[p][offset] = y == x ? coeff_quadratic_to_compact[p][x][y] : GF2Field.addElem(coeff_quadratic_to_compact[p][x][y], coeff_quadratic_to_compact[p][y][x]);
                    ++offset;
                }
            }
        }
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

