/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.math.ec.rfc8032;

import com.nbcb.bouncycastle.crypto.digests.SHA512Digest;
import com.nbcb.bouncycastle.math.ec.rfc7748.X25519Field;
import com.nbcb.bouncycastle.math.raw.Interleave;
import com.nbcb.bouncycastle.math.raw.Nat;
import com.nbcb.bouncycastle.math.raw.Nat256;
import com.nbcb.bouncycastle.util.Arrays;

public abstract class Ed25519 {
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int POINT_BYTES = 32;
    private static final int SCALAR_INTS = 8;
    private static final int SCALAR_BYTES = 32;
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] L = new int[]{1559614445, 1477600026, -1560830762, 350157278, 0, 0, 0, 0x10000000};
    private static final int L0 = -50998291;
    private static final int L1 = 19280294;
    private static final int L2 = 127719000;
    private static final int L3 = -6428113;
    private static final int L4 = 5343;
    private static final int[] B_x = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] B_y = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] C_d = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] C_d2 = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] C_d4 = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static final int WNAF_WIDTH_BASE = 7;
    private static final int PRECOMP_BLOCKS = 8;
    private static final int PRECOMP_TEETH = 4;
    private static final int PRECOMP_SPACING = 8;
    private static final int PRECOMP_POINTS = 8;
    private static final int PRECOMP_MASK = 7;
    private static PointExt[] precompBaseTable = null;
    private static int[] precompBase = null;

    private static byte[] calculateS(byte[] r, byte[] k, byte[] s) {
        int[] t = new int[16];
        Ed25519.decodeScalar(r, 0, t);
        int[] u = new int[8];
        Ed25519.decodeScalar(k, 0, u);
        int[] v = new int[8];
        Ed25519.decodeScalar(s, 0, v);
        Nat256.mulAddTo(u, v, t);
        byte[] result = new byte[64];
        for (int i = 0; i < t.length; ++i) {
            Ed25519.encode32(t[i], result, i * 4);
        }
        return Ed25519.reduceScalar(result);
    }

    private static boolean checkPointVar(byte[] p) {
        int[] t = new int[8];
        Ed25519.decode32(p, 0, t, 0, 8);
        t[7] = t[7] & Integer.MAX_VALUE;
        return !Nat256.gte(t, P);
    }

    private static boolean checkScalarVar(byte[] s) {
        int[] n = new int[8];
        Ed25519.decodeScalar(s, 0, n);
        return !Nat256.gte(n, L);
    }

    private static int decode24(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= (bs[++off] & 0xFF) << 16;
    }

    private static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    private static void decode32(byte[] bs, int bsOff, int[] n, int nOff, int nLen) {
        for (int i = 0; i < nLen; ++i) {
            n[nOff + i] = Ed25519.decode32(bs, bsOff + i * 4);
        }
    }

    private static boolean decodePointVar(byte[] p, int pOff, boolean negate, PointExt r) {
        byte[] py = Arrays.copyOfRange(p, pOff, pOff + 32);
        if (!Ed25519.checkPointVar(py)) {
            return false;
        }
        int x_0 = (py[31] & 0x80) >>> 7;
        py[31] = (byte)(py[31] & 0x7F);
        X25519Field.decode(py, 0, r.y);
        int[] u = X25519Field.create();
        int[] v = X25519Field.create();
        X25519Field.sqr(r.y, u);
        X25519Field.mul(C_d, u, v);
        X25519Field.subOne(u);
        X25519Field.addOne(v);
        if (!X25519Field.sqrtRatioVar(u, v, r.x)) {
            return false;
        }
        X25519Field.normalize(r.x);
        if (x_0 == 1 && X25519Field.isZeroVar(r.x)) {
            return false;
        }
        if (negate ^ x_0 != (r.x[0] & 1)) {
            X25519Field.negate(r.x, r.x);
        }
        Ed25519.pointExtendXY(r);
        return true;
    }

    private static void decodeScalar(byte[] k, int kOff, int[] n) {
        Ed25519.decode32(k, kOff, n, 0, 8);
    }

    private static void encode24(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
    }

    private static void encode32(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    private static void encode56(long n, byte[] bs, int off) {
        Ed25519.encode32((int)n, bs, off);
        Ed25519.encode24((int)(n >>> 32), bs, off + 4);
    }

    private static void encodePoint(PointExt p, byte[] r, int rOff) {
        int[] x = X25519Field.create();
        int[] y = X25519Field.create();
        X25519Field.inv(p.z, y);
        X25519Field.mul(p.x, y, x);
        X25519Field.mul(p.y, y, y);
        X25519Field.normalize(x);
        X25519Field.normalize(y);
        X25519Field.encode(y, r, rOff);
        int n = rOff + 32 - 1;
        r[n] = (byte)(r[n] | (x[0] & 1) << 7);
    }

    public static void generatePublicKey(byte[] sk, int skOff, byte[] pk, int pkOff) {
        SHA512Digest d = new SHA512Digest();
        byte[] h = new byte[d.getDigestSize()];
        d.update(sk, skOff, 32);
        d.doFinal(h, 0);
        byte[] s = new byte[32];
        Ed25519.pruneScalar(h, 0, s);
        Ed25519.scalarMultBaseEncoded(s, pk, pkOff);
    }

    private static byte[] getWNAF(int[] n, int width) {
        int[] t = new int[16];
        int tPos = t.length;
        int c = 0;
        int i = 8;
        while (--i >= 0) {
            int next = n[i];
            t[--tPos] = next >>> 16 | c << 16;
            t[--tPos] = c = next;
        }
        byte[] ws = new byte[256];
        int pow2 = 1 << width;
        int mask = pow2 - 1;
        int sign = pow2 >>> 1;
        int j = 0;
        int carry = 0;
        int i2 = 0;
        while (i2 < t.length) {
            int word = t[i2];
            while (j < 16) {
                int word16 = word >>> j;
                int bit = word16 & 1;
                if (bit == carry) {
                    ++j;
                    continue;
                }
                int digit = (word16 & mask) + carry;
                carry = digit & sign;
                digit -= carry << 1;
                carry >>>= width - 1;
                ws[(i2 << 4) + j] = (byte)digit;
                j += width;
            }
            ++i2;
            j -= 16;
        }
        return ws;
    }

    private static void implSign(SHA512Digest d, byte[] h, byte[] s, byte[] pk, int pkOff, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        d.update(h, 32, 32);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0);
        byte[] r = Ed25519.reduceScalar(h);
        byte[] R = new byte[32];
        Ed25519.scalarMultBaseEncoded(r, R, 0);
        d.update(R, 0, 32);
        d.update(pk, 0, 32);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0);
        byte[] k = Ed25519.reduceScalar(h);
        byte[] S = Ed25519.calculateS(r, k, s);
        System.arraycopy(R, 0, sig, sigOff, 32);
        System.arraycopy(S, 0, sig, sigOff + 32, 32);
    }

    private static void pointAddVar(boolean negate, PointExt p, PointExt r) {
        int[] g;
        int[] f;
        int[] d;
        int[] c;
        int[] A = X25519Field.create();
        int[] B = X25519Field.create();
        int[] C = X25519Field.create();
        int[] D = X25519Field.create();
        int[] E = X25519Field.create();
        int[] F = X25519Field.create();
        int[] G = X25519Field.create();
        int[] H = X25519Field.create();
        if (negate) {
            c = D;
            d = C;
            f = G;
            g = F;
        } else {
            c = C;
            d = D;
            f = F;
            g = G;
        }
        X25519Field.apm(r.y, r.x, B, A);
        X25519Field.apm(p.y, p.x, d, c);
        X25519Field.mul(A, C, A);
        X25519Field.mul(B, D, B);
        X25519Field.mul(r.t, p.t, C);
        X25519Field.mul(C, C_d2, C);
        X25519Field.mul(r.z, p.z, D);
        X25519Field.add(D, D, D);
        X25519Field.apm(B, A, H, E);
        X25519Field.apm(D, C, g, f);
        X25519Field.carry(g);
        X25519Field.mul(E, F, r.x);
        X25519Field.mul(G, H, r.y);
        X25519Field.mul(F, G, r.z);
        X25519Field.mul(E, H, r.t);
    }

    private static void pointAddPrecomp(PointPrecomp p, PointExt r) {
        int[] A = X25519Field.create();
        int[] B = X25519Field.create();
        int[] C = X25519Field.create();
        int[] E = X25519Field.create();
        int[] F = X25519Field.create();
        int[] G = X25519Field.create();
        int[] H = X25519Field.create();
        X25519Field.apm(r.y, r.x, B, A);
        X25519Field.mul(A, p.ymx_h, A);
        X25519Field.mul(B, p.ypx_h, B);
        X25519Field.mul(r.t, p.xyd, C);
        X25519Field.apm(B, A, H, E);
        X25519Field.apm(r.z, C, G, F);
        X25519Field.carry(G);
        X25519Field.mul(E, F, r.x);
        X25519Field.mul(G, H, r.y);
        X25519Field.mul(F, G, r.z);
        X25519Field.mul(E, H, r.t);
    }

    private static PointExt pointCopy(PointExt p) {
        PointExt r = new PointExt();
        X25519Field.copy(p.x, 0, r.x, 0);
        X25519Field.copy(p.y, 0, r.y, 0);
        X25519Field.copy(p.z, 0, r.z, 0);
        X25519Field.copy(p.t, 0, r.t, 0);
        return r;
    }

    private static void pointDouble(PointExt r) {
        int[] A = X25519Field.create();
        int[] B = X25519Field.create();
        int[] C = X25519Field.create();
        int[] E = X25519Field.create();
        int[] F = X25519Field.create();
        int[] G = X25519Field.create();
        int[] H = X25519Field.create();
        X25519Field.sqr(r.x, A);
        X25519Field.sqr(r.y, B);
        X25519Field.sqr(r.z, C);
        X25519Field.add(C, C, C);
        X25519Field.apm(A, B, H, G);
        X25519Field.add(r.x, r.y, E);
        X25519Field.sqr(E, E);
        X25519Field.sub(H, E, E);
        X25519Field.add(C, G, F);
        X25519Field.carry(F);
        X25519Field.mul(E, F, r.x);
        X25519Field.mul(G, H, r.y);
        X25519Field.mul(F, G, r.z);
        X25519Field.mul(E, H, r.t);
    }

    private static void pointExtendXY(PointExt p) {
        X25519Field.one(p.z);
        X25519Field.mul(p.x, p.y, p.t);
    }

    private static void pointLookup(int block, int index, PointPrecomp p) {
        int off = block * 8 * 3 * 10;
        for (int i = 0; i < 8; ++i) {
            int mask = (i ^ index) - 1 >> 31;
            Nat.cmov(10, mask, precompBase, off, p.ypx_h, 0);
            Nat.cmov(10, mask, precompBase, off += 10, p.ymx_h, 0);
            Nat.cmov(10, mask, precompBase, off += 10, p.xyd, 0);
            off += 10;
        }
    }

    private static PointExt[] pointPrecompVar(PointExt p, int count) {
        PointExt d = Ed25519.pointCopy(p);
        Ed25519.pointDouble(d);
        PointExt[] table = new PointExt[count];
        table[0] = Ed25519.pointCopy(p);
        for (int i = 1; i < count; ++i) {
            table[i] = Ed25519.pointCopy(table[i - 1]);
            Ed25519.pointAddVar(false, d, table[i]);
        }
        return table;
    }

    private static void pointSetNeutral(PointExt p) {
        X25519Field.zero(p.x);
        X25519Field.one(p.y);
        X25519Field.one(p.z);
        X25519Field.zero(p.t);
    }

    public static synchronized void precompute() {
        if (precompBase != null) {
            return;
        }
        PointExt p = new PointExt();
        X25519Field.copy(B_x, 0, p.x, 0);
        X25519Field.copy(B_y, 0, p.y, 0);
        Ed25519.pointExtendXY(p);
        precompBaseTable = Ed25519.pointPrecompVar(p, 32);
        precompBase = new int[1920];
        int off = 0;
        for (int b = 0; b < 8; ++b) {
            PointExt[] ds = new PointExt[4];
            PointExt sum = new PointExt();
            Ed25519.pointSetNeutral(sum);
            for (int t = 0; t < 4; ++t) {
                Ed25519.pointAddVar(true, p, sum);
                Ed25519.pointDouble(p);
                ds[t] = Ed25519.pointCopy(p);
                for (int s = 1; s < 8; ++s) {
                    Ed25519.pointDouble(p);
                }
            }
            PointExt[] points = new PointExt[8];
            int k = 0;
            points[k++] = sum;
            for (int t = 0; t < 3; ++t) {
                int size = 1 << t;
                for (int j = 0; j < size; ++j) {
                    points[k] = Ed25519.pointCopy(points[k - size]);
                    Ed25519.pointAddVar(false, ds[t], points[k++]);
                }
            }
            for (int i = 0; i < 8; ++i) {
                PointExt q = points[i];
                int[] x = X25519Field.create();
                int[] y = X25519Field.create();
                X25519Field.add(q.z, q.z, x);
                X25519Field.inv(x, y);
                X25519Field.mul(q.x, y, x);
                X25519Field.mul(q.y, y, y);
                PointPrecomp r = new PointPrecomp();
                X25519Field.apm(y, x, r.ypx_h, r.ymx_h);
                X25519Field.mul(x, y, r.xyd);
                X25519Field.mul(r.xyd, C_d4, r.xyd);
                X25519Field.normalize(r.ypx_h);
                X25519Field.normalize(r.ymx_h);
                X25519Field.copy(r.ypx_h, 0, precompBase, off);
                X25519Field.copy(r.ymx_h, 0, precompBase, off += 10);
                X25519Field.copy(r.xyd, 0, precompBase, off += 10);
                off += 10;
            }
        }
    }

    private static void pruneScalar(byte[] n, int nOff, byte[] r) {
        System.arraycopy(n, nOff, r, 0, 32);
        r[0] = (byte)(r[0] & 0xF8);
        r[31] = (byte)(r[31] & 0x7F);
        r[31] = (byte)(r[31] | 0x40);
    }

    private static byte[] reduceScalar(byte[] n) {
        long x00 = (long)Ed25519.decode32(n, 0) & 0xFFFFFFFFL;
        long x01 = (long)(Ed25519.decode24(n, 4) << 4) & 0xFFFFFFFFL;
        long x02 = (long)Ed25519.decode32(n, 7) & 0xFFFFFFFFL;
        long x03 = (long)(Ed25519.decode24(n, 11) << 4) & 0xFFFFFFFFL;
        long x04 = (long)Ed25519.decode32(n, 14) & 0xFFFFFFFFL;
        long x05 = (long)(Ed25519.decode24(n, 18) << 4) & 0xFFFFFFFFL;
        long x06 = (long)Ed25519.decode32(n, 21) & 0xFFFFFFFFL;
        long x07 = (long)(Ed25519.decode24(n, 25) << 4) & 0xFFFFFFFFL;
        long x08 = (long)Ed25519.decode32(n, 28) & 0xFFFFFFFFL;
        long x09 = (long)(Ed25519.decode24(n, 32) << 4) & 0xFFFFFFFFL;
        long x10 = (long)Ed25519.decode32(n, 35) & 0xFFFFFFFFL;
        long x11 = (long)(Ed25519.decode24(n, 39) << 4) & 0xFFFFFFFFL;
        long x12 = (long)Ed25519.decode32(n, 42) & 0xFFFFFFFFL;
        long x13 = (long)(Ed25519.decode24(n, 46) << 4) & 0xFFFFFFFFL;
        long x14 = (long)Ed25519.decode32(n, 49) & 0xFFFFFFFFL;
        long x15 = (long)(Ed25519.decode24(n, 53) << 4) & 0xFFFFFFFFL;
        long x16 = (long)Ed25519.decode32(n, 56) & 0xFFFFFFFFL;
        long x17 = (long)(Ed25519.decode24(n, 60) << 4) & 0xFFFFFFFFL;
        long x18 = (long)n[63] & 0xFFL;
        x09 -= x18 * -50998291L;
        x10 -= x18 * 19280294L;
        x11 -= x18 * 127719000L;
        x12 -= x18 * -6428113L;
        x13 -= x18 * 5343L;
        x17 += x16 >> 28;
        x16 &= 0xFFFFFFFL;
        x08 -= x17 * -50998291L;
        x09 -= x17 * 19280294L;
        x10 -= x17 * 127719000L;
        x11 -= x17 * -6428113L;
        x12 -= x17 * 5343L;
        x07 -= x16 * -50998291L;
        x08 -= x16 * 19280294L;
        x09 -= x16 * 127719000L;
        x10 -= x16 * -6428113L;
        x11 -= x16 * 5343L;
        x15 += x14 >> 28;
        x14 &= 0xFFFFFFFL;
        x06 -= x15 * -50998291L;
        x07 -= x15 * 19280294L;
        x08 -= x15 * 127719000L;
        x09 -= x15 * -6428113L;
        x10 -= x15 * 5343L;
        x05 -= x14 * -50998291L;
        x06 -= x14 * 19280294L;
        x07 -= x14 * 127719000L;
        x08 -= x14 * -6428113L;
        x09 -= x14 * 5343L;
        x13 += x12 >> 28;
        x12 &= 0xFFFFFFFL;
        x04 -= x13 * -50998291L;
        x05 -= x13 * 19280294L;
        x06 -= x13 * 127719000L;
        x07 -= x13 * -6428113L;
        x08 -= x13 * 5343L;
        x12 += x11 >> 28;
        x11 &= 0xFFFFFFFL;
        x03 -= x12 * -50998291L;
        x04 -= x12 * 19280294L;
        x05 -= x12 * 127719000L;
        x06 -= x12 * -6428113L;
        x07 -= x12 * 5343L;
        x11 += x10 >> 28;
        x10 &= 0xFFFFFFFL;
        x02 -= x11 * -50998291L;
        x03 -= x11 * 19280294L;
        x04 -= x11 * 127719000L;
        x05 -= x11 * -6428113L;
        x06 -= x11 * 5343L;
        x10 += x09 >> 28;
        x09 &= 0xFFFFFFFL;
        x01 -= x10 * -50998291L;
        x02 -= x10 * 19280294L;
        x03 -= x10 * 127719000L;
        x04 -= x10 * -6428113L;
        x05 -= x10 * 5343L;
        x08 += x07 >> 28;
        x07 &= 0xFFFFFFFL;
        x09 += x08 >> 28;
        long t = (x08 &= 0xFFFFFFFL) >>> 27;
        x01 -= x09 * 19280294L;
        x02 -= x09 * 127719000L;
        x03 -= x09 * -6428113L;
        x04 -= x09 * 5343L;
        x00 &= 0xFFFFFFFL;
        x01 &= 0xFFFFFFFL;
        x02 &= 0xFFFFFFFL;
        x03 &= 0xFFFFFFFL;
        x04 &= 0xFFFFFFFL;
        x05 &= 0xFFFFFFFL;
        x06 &= 0xFFFFFFFL;
        x07 &= 0xFFFFFFFL;
        x09 = (x08 += (x07 += (x06 += (x05 += (x04 += (x03 += (x02 += (x01 += (x00 -= (x09 += t) * -50998291L) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        x08 &= 0xFFFFFFFL;
        x01 += x09 & 0x12631A6L;
        x02 += x09 & 0x79CD658L;
        x03 += x09 & 0xFFFFFFFFFF9DEA2FL;
        x04 += x09 & 0x14DFL;
        x00 &= 0xFFFFFFFL;
        x01 &= 0xFFFFFFFL;
        x02 &= 0xFFFFFFFL;
        x03 &= 0xFFFFFFFL;
        x04 &= 0xFFFFFFFL;
        x05 &= 0xFFFFFFFL;
        x06 &= 0xFFFFFFFL;
        x08 += (x07 += (x06 += (x05 += (x04 += (x03 += (x02 += (x01 += (x00 += (x09 -= t) & 0xFFFFFFFFFCF5D3EDL) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28) >> 28;
        byte[] r = new byte[32];
        Ed25519.encode56(x00 | x01 << 28, r, 0);
        Ed25519.encode56(x02 | x03 << 28, r, 7);
        Ed25519.encode56(x04 | x05 << 28, r, 14);
        Ed25519.encode56(x06 | (x07 &= 0xFFFFFFFL) << 28, r, 21);
        Ed25519.encode32((int)x08, r, 28);
        return r;
    }

    private static void scalarMultBase(byte[] k, PointExt r) {
        Ed25519.precompute();
        Ed25519.pointSetNeutral(r);
        int[] n = new int[8];
        Ed25519.decodeScalar(k, 0, n);
        Nat.cadd(8, ~n[0] & 1, n, L, n);
        Nat.shiftDownBit(8, n, 1);
        for (int i = 0; i < 8; ++i) {
            n[i] = Interleave.shuffle2(n[i]);
        }
        PointPrecomp p = new PointPrecomp();
        int cOff = 28;
        while (true) {
            for (int b = 0; b < 8; ++b) {
                int w = n[b] >>> cOff;
                int sign = w >>> 3 & 1;
                int abs = (w ^ -sign) & 7;
                Ed25519.pointLookup(b, abs, p);
                X25519Field.cswap(sign, p.ypx_h, p.ymx_h);
                X25519Field.cnegate(sign, p.xyd);
                Ed25519.pointAddPrecomp(p, r);
            }
            if ((cOff -= 4) < 0) break;
            Ed25519.pointDouble(r);
        }
    }

    private static void scalarMultBaseEncoded(byte[] k, byte[] r, int rOff) {
        PointExt p = new PointExt();
        Ed25519.scalarMultBase(k, p);
        Ed25519.encodePoint(p, r, rOff);
    }

    private static void scalarMultStraussVar(int[] nb, int[] np, PointExt p, PointExt r) {
        int bit;
        Ed25519.precompute();
        int width = 5;
        byte[] ws_b = Ed25519.getWNAF(nb, 7);
        byte[] ws_p = Ed25519.getWNAF(np, 5);
        PointExt[] tp = Ed25519.pointPrecompVar(p, 8);
        Ed25519.pointSetNeutral(r);
        for (bit = 255; bit > 0 && (ws_b[bit] | ws_p[bit]) == 0; --bit) {
        }
        while (true) {
            byte wp;
            byte wb;
            if ((wb = ws_b[bit]) != 0) {
                int sign = wb >> 31;
                int index = (wb ^ sign) >>> 1;
                Ed25519.pointAddVar(sign != 0, precompBaseTable[index], r);
            }
            if ((wp = ws_p[bit]) != 0) {
                int sign = wp >> 31;
                int index = (wp ^ sign) >>> 1;
                Ed25519.pointAddVar(sign != 0, tp[index], r);
            }
            if (--bit < 0) break;
            Ed25519.pointDouble(r);
        }
    }

    public static void sign(byte[] sk, int skOff, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        SHA512Digest d = new SHA512Digest();
        byte[] h = new byte[d.getDigestSize()];
        d.update(sk, skOff, 32);
        d.doFinal(h, 0);
        byte[] s = new byte[32];
        Ed25519.pruneScalar(h, 0, s);
        byte[] pk = new byte[32];
        Ed25519.scalarMultBaseEncoded(s, pk, 0);
        Ed25519.implSign(d, h, s, pk, 0, m, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        SHA512Digest d = new SHA512Digest();
        byte[] h = new byte[d.getDigestSize()];
        d.update(sk, skOff, 32);
        d.doFinal(h, 0);
        byte[] s = new byte[32];
        Ed25519.pruneScalar(h, 0, s);
        Ed25519.implSign(d, h, s, pk, pkOff, m, mOff, mLen, sig, sigOff);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] m, int mOff, int mLen) {
        byte[] R = Arrays.copyOfRange(sig, sigOff, sigOff + 32);
        byte[] S = Arrays.copyOfRange(sig, sigOff + 32, sigOff + 64);
        if (!Ed25519.checkPointVar(R)) {
            return false;
        }
        if (!Ed25519.checkScalarVar(S)) {
            return false;
        }
        PointExt pA = new PointExt();
        if (!Ed25519.decodePointVar(pk, pkOff, true, pA)) {
            return false;
        }
        SHA512Digest d = new SHA512Digest();
        byte[] h = new byte[d.getDigestSize()];
        d.update(R, 0, 32);
        d.update(pk, pkOff, 32);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0);
        byte[] k = Ed25519.reduceScalar(h);
        int[] nS = new int[8];
        Ed25519.decodeScalar(S, 0, nS);
        int[] nA = new int[8];
        Ed25519.decodeScalar(k, 0, nA);
        PointExt pR = new PointExt();
        Ed25519.scalarMultStraussVar(nS, nA, pA, pR);
        byte[] check = new byte[32];
        Ed25519.encodePoint(pR, check, 0);
        return Arrays.areEqual(check, R);
    }

    private static class PointPrecomp {
        int[] ypx_h = X25519Field.create();
        int[] ymx_h = X25519Field.create();
        int[] xyd = X25519Field.create();

        private PointPrecomp() {
        }
    }

    private static class PointExt {
        int[] x = X25519Field.create();
        int[] y = X25519Field.create();
        int[] z = X25519Field.create();
        int[] t = X25519Field.create();

        private PointExt() {
        }
    }
}

