/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.CipherParameters;
import com.nbcb.bouncycastle.crypto.Digest;
import com.nbcb.bouncycastle.crypto.StreamCipher;
import com.nbcb.bouncycastle.crypto.params.KeyParameter;
import com.nbcb.bouncycastle.crypto.params.ParametersWithIV;
import com.nbcb.bouncycastle.crypto.tls.TlsCipher;
import com.nbcb.bouncycastle.crypto.tls.TlsContext;
import com.nbcb.bouncycastle.crypto.tls.TlsFatalAlert;
import com.nbcb.bouncycastle.crypto.tls.TlsMac;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import com.nbcb.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;
    protected boolean usesNonce;

    public TlsStreamCipher(TlsContext context, StreamCipher clientWriteCipher, StreamCipher serverWriteCipher, Digest clientWriteDigest, Digest serverWriteDigest, int cipherKeySize, boolean usesNonce) throws IOException {
        CipherParameters decryptParams;
        CipherParameters encryptParams;
        boolean isServer = context.isServer();
        this.context = context;
        this.usesNonce = usesNonce;
        this.encryptCipher = clientWriteCipher;
        this.decryptCipher = serverWriteCipher;
        int key_block_size = 2 * cipherKeySize + clientWriteDigest.getDigestSize() + serverWriteDigest.getDigestSize();
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        TlsMac clientWriteMac = new TlsMac(context, clientWriteDigest, key_block, offset, clientWriteDigest.getDigestSize());
        TlsMac serverWriteMac = new TlsMac(context, serverWriteDigest, key_block, offset += clientWriteDigest.getDigestSize(), serverWriteDigest.getDigestSize());
        KeyParameter clientWriteKey = new KeyParameter(key_block, offset += serverWriteDigest.getDigestSize(), cipherKeySize);
        KeyParameter serverWriteKey = new KeyParameter(key_block, offset += cipherKeySize, cipherKeySize);
        if ((offset += cipherKeySize) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (isServer) {
            this.writeMac = serverWriteMac;
            this.readMac = clientWriteMac;
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            encryptParams = serverWriteKey;
            decryptParams = clientWriteKey;
        } else {
            this.writeMac = clientWriteMac;
            this.readMac = serverWriteMac;
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            encryptParams = clientWriteKey;
            decryptParams = serverWriteKey;
        }
        if (usesNonce) {
            byte[] dummyNonce = new byte[8];
            encryptParams = new ParametersWithIV(encryptParams, dummyNonce);
            decryptParams = new ParametersWithIV(decryptParams, dummyNonce);
        }
        this.encryptCipher.init(true, encryptParams);
        this.decryptCipher.init(false, decryptParams);
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) {
        if (this.usesNonce) {
            this.updateIV(this.encryptCipher, true, seqNo);
        }
        byte[] outBuf = new byte[len + this.writeMac.getSize()];
        this.encryptCipher.processBytes(plaintext, offset, len, outBuf, 0);
        byte[] mac = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        this.encryptCipher.processBytes(mac, 0, mac.length, outBuf, len);
        return outBuf;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int macSize;
        if (this.usesNonce) {
            this.updateIV(this.decryptCipher, false, seqNo);
        }
        if (len < (macSize = this.readMac.getSize())) {
            throw new TlsFatalAlert(50);
        }
        int plaintextLength = len - macSize;
        byte[] deciphered = new byte[len];
        this.decryptCipher.processBytes(ciphertext, offset, len, deciphered, 0);
        this.checkMAC(seqNo, type, deciphered, plaintextLength, len, deciphered, 0, plaintextLength);
        return Arrays.copyOfRange(deciphered, 0, plaintextLength);
    }

    protected void checkMAC(long seqNo, short type, byte[] recBuf, int recStart, int recEnd, byte[] calcBuf, int calcOff, int calcLen) throws IOException {
        byte[] computedMac;
        byte[] receivedMac = Arrays.copyOfRange(recBuf, recStart, recEnd);
        if (!Arrays.constantTimeAreEqual(receivedMac, computedMac = this.readMac.calculateMac(seqNo, type, calcBuf, calcOff, calcLen))) {
            throw new TlsFatalAlert(20);
        }
    }

    protected void updateIV(StreamCipher cipher, boolean forEncryption, long seqNo) {
        byte[] nonce = new byte[8];
        TlsUtils.writeUint64(seqNo, nonce, 0);
        cipher.init(forEncryption, new ParametersWithIV(null, nonce));
    }
}

