/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.paddings;

import com.nbcb.bouncycastle.crypto.InvalidCipherTextException;
import com.nbcb.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO7816d4Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "ISO7816-4";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        int added = in.length - inOff;
        in[inOff] = -128;
        ++inOff;
        while (inOff < in.length) {
            in[inOff] = 0;
            ++inOff;
        }
        return added;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count;
        for (count = in.length - 1; count > 0 && in[count] == 0; --count) {
        }
        if (in[count] != -128) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return in.length - count;
    }
}

