/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.modes.gcm;

import com.nbcb.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.nbcb.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.nbcb.bouncycastle.util.Arrays;
import java.util.Vector;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    @Override
    public void init(byte[] x) {
        long[] y = GCMUtil.asLongs(x);
        if (this.lookupPowX2 != null && Arrays.areEqual(y, (long[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(y);
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        long[] y = GCMUtil.oneAsLongs();
        int bit = 0;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                this.ensureAvailable(bit);
                GCMUtil.multiply(y, (long[])this.lookupPowX2.elementAt(bit));
            }
            ++bit;
            pow >>>= 1;
        }
        GCMUtil.asBytes(y, output);
    }

    private void ensureAvailable(int bit) {
        int count = this.lookupPowX2.size();
        if (count <= bit) {
            long[] tmp = (long[])this.lookupPowX2.elementAt(count - 1);
            do {
                tmp = Arrays.clone(tmp);
                GCMUtil.square(tmp, tmp);
                this.lookupPowX2.addElement(tmp);
            } while (++count <= bit);
        }
    }
}

