/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.generators;

import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.nbcb.bouncycastle.crypto.KeyGenerationParameters;
import com.nbcb.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.nbcb.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.nbcb.bouncycastle.crypto.params.DHParameters;
import com.nbcb.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.nbcb.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

