/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.ec;

import com.nbcb.bouncycastle.crypto.CipherParameters;
import com.nbcb.bouncycastle.crypto.ec.ECDecryptor;
import com.nbcb.bouncycastle.crypto.ec.ECPair;
import com.nbcb.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.nbcb.bouncycastle.math.ec.ECAlgorithms;
import com.nbcb.bouncycastle.math.ec.ECCurve;
import com.nbcb.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    @Override
    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECCurve curve = this.key.getParameters().getCurve();
        ECPoint tmp = ECAlgorithms.cleanPoint(curve, pair.getX()).multiply(this.key.getD());
        return ECAlgorithms.cleanPoint(curve, pair.getY()).subtract(tmp).normalize();
    }
}

