/*
 * Decompiled with CFR 0.152.
 */
package com.nbopen.api;

import com.nbopen.api.SDKRequest;
import com.nbopen.api.SDKResponse;
import com.nbopen.cl.NBClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class NBOpenSDK {
    private static final int BUFFER_SIZE = 512;
    private static final String openSDKName = "com.nbopen.sdk.OpenSDK";
    private static Class openSDK = null;
    private static Boolean isInit = false;
    private static NBClassLoader nbClassLoader = null;

    public static String getVersionInfo() {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("getVersionInfo", new Class[0]);
            return (String)method.invoke(openSDK.newInstance(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentDate() {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("getCurrentDate", new Class[0]);
            return (String)method.invoke(openSDK.newInstance(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getCurrentTime() {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("getCurrentTime", new Class[0]);
            return (String)method.invoke(openSDK.newInstance(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getRandom() {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("getRandom", new Class[0]);
            return (String)method.invoke(openSDK.newInstance(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean init(InputStream stream) {
        try {
            if (!isInit.booleanValue()) {
                NBOpenSDK.obtionOpenSDKClass();
                Method method = openSDK.getMethod("init", InputStream.class);
                isInit = (Boolean)method.invoke(openSDK.newInstance(), stream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isInit = false;
        }
        return isInit;
    }

    public static boolean init(String pathOrContent) {
        try {
            if (!isInit.booleanValue()) {
                NBOpenSDK.obtionOpenSDKClass();
                Method method = openSDK.getMethod("init", String.class);
                isInit = (Boolean)method.invoke(openSDK.newInstance(), pathOrContent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isInit = false;
        }
        return isInit;
    }

    public static boolean updateConfig(Object configInfo) {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("updateConfig", Object.class);
            isInit = (Boolean)method.invoke(openSDK.newInstance(), configInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInit;
    }

    public static SDKResponse send(SDKRequest request) throws Exception {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("send", SDKRequest.class);
            return (SDKResponse)method.invoke(openSDK.newInstance(), request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static SDKResponse encryptMessage(SDKRequest request) throws Exception {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("encryptMessage", SDKRequest.class);
            return (SDKResponse)method.invoke(openSDK.newInstance(), request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static SDKResponse decryptMessage(SDKRequest request) throws Exception {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("decryptMessage", SDKRequest.class);
            return (SDKResponse)method.invoke(openSDK.newInstance(), request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static SDKResponse getFile(SDKRequest request) throws Exception {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("getFileByHttp", SDKRequest.class);
            return (SDKResponse)method.invoke(openSDK.newInstance(), request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static SDKResponse putFile(SDKRequest request) throws Exception {
        try {
            NBOpenSDK.obtionOpenSDKClass();
            Method method = openSDK.getMethod("putFileByHttp", SDKRequest.class);
            return (SDKResponse)method.invoke(openSDK.newInstance(), request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static void obtionOpenSDKClass() throws ClassNotFoundException {
        if (openSDK == null) {
            openSDK = nbClassLoader.loadClass(openSDKName);
        }
    }

    private static String readCurrentJar(String jarPath) {
        if (!jarPath.contains("!")) {
            return jarPath;
        }
        if (jarPath.endsWith("!")) {
            jarPath = jarPath.substring(0, jarPath.length() - 1);
        }
        String userDir = System.getProperty("user.dir");
        System.out.println("nbsdk-userDir: " + userDir);
        File folder = new File(userDir + File.separator + "nbsdk" + File.separator + "lib");
        if (!folder.exists()) {
            try {
                folder.mkdirs();
            }
            catch (Exception e) {
                throw new RuntimeException("mkdir failed " + folder.getPath());
            }
        }
        folder.deleteOnExit();
        String[] path = jarPath.split("!");
        String jar = path[0];
        String temp = path[1];
        if (temp.contains("openBasicSDK")) {
            temp = temp.split("openBasicSDK")[0];
        }
        NBOpenSDK.printMsg("nbsdk-temp=" + temp);
        NBOpenSDK.printMsg("nbsdk-temp.startWith=" + temp.startsWith(File.separator));
        if (temp.startsWith("/")) {
            temp = temp.substring(1, temp.length());
        }
        NBOpenSDK.unzipJarJar(jar, temp, folder.getAbsolutePath());
        String currentJarPath = folder.getPath() + File.separator + path[1].split(temp)[1];
        NBOpenSDK.printMsg("nbsdk-currentJarPath:" + currentJarPath);
        return currentJarPath;
    }

    private static void unzipJarJar(String jarPath, String srcPath, String dstPath) {
        try {
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                NBOpenSDK.printMsg("nbsdk-unzipJarJar-name=" + name + "         srcPath=" + srcPath);
                String[] split = name.split(srcPath);
                NBOpenSDK.printMsg("nbsdk-unzipJarJar-split.length = " + split.length);
                if (!name.startsWith(srcPath) || split.length != 2) continue;
                String jarName = split[1];
                NBOpenSDK.printMsg("nbsdk-unzipJarJar-split[0]=" + split[0]);
                NBOpenSDK.printMsg("nbsdk-unzipJarJar-split[1]=" + jarName);
                if (!jarName.startsWith("openBasicSDK")) continue;
                NBOpenSDK.printMsg("nbsdk-unzipJarJar-start unzip jar=" + name);
                NBOpenSDK.printMsg("nbsdk-unzipJarJar-dstPath=" + dstPath);
                File file = new File(dstPath, jarName);
                NBOpenSDK.unpack(jarFile, jarEntry, file);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static File unpackToFolder(File jarPath, NBClassLoader classLoader) {
        try {
            String userDir = System.getProperty("user.dir");
            System.out.println("nbsdk-userDir: " + userDir);
            File folder = new File(userDir + File.separator + "nbsdk" + File.separator + "lib");
            if (!folder.exists()) {
                try {
                    folder.mkdirs();
                }
                catch (Exception e) {
                    throw new RuntimeException("mkdir failed " + folder.getPath());
                }
            }
            folder.deleteOnExit();
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                String[] split = name.split("/");
                if (!name.startsWith("sdklib/") || split.length <= 1) continue;
                File file = new File(folder, split[1]);
                NBOpenSDK.printMsg("nbsdk- unpack: " + file.getPath());
                NBOpenSDK.unpack(jarFile, jarEntry, file);
                URL url = file.toURI().toURL();
                NBOpenSDK.printMsg("add jar to classLoader: " + url.toString());
                classLoader.addURL(url);
            }
            return folder;
        }
        catch (Exception e) {
            System.out.println("nbsdk- unpack to folder error" + e);
            throw new RuntimeException(e);
        }
    }

    private static void unpack(JarFile jarFile, JarEntry entry, File file) throws IOException {
        NBOpenSDK.printMsg("unpack jarPath = " + file.getPath());
        try (InputStream inputStream = jarFile.getInputStream(entry);
             FileOutputStream outputStream = new FileOutputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[512];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
    }

    private static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                File[] listFiles;
                for (File f : listFiles = file.listFiles()) {
                    NBOpenSDK.deleteFile(f);
                }
            }
            file.delete();
        }
    }

    private static void printMsg(String data) {
        String debuged = System.getProperty("nbsdk.sys.debug", "false");
        if (Boolean.parseBoolean(debuged)) {
            System.out.println(data);
        }
    }

    static {
        File files = null;
        try {
            String path = NBOpenSDK.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (path.startsWith("file:")) {
                path = path.substring("file:".length(), path.length());
            }
            System.out.println("nbsdk-jarpath:" + path);
            nbClassLoader = new NBClassLoader(new URL[0], NBOpenSDK.class.getClassLoader());
            NBOpenSDK.printMsg("SDK-classLoader: " + nbClassLoader);
            path = NBOpenSDK.readCurrentJar(path);
            files = NBOpenSDK.unpackToFolder(new File(path), nbClassLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

