/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.symmetric;

import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.engines.NoekeonEngine;
import cn.com.infosec.jce.provider.JCEBlockCipher;
import cn.com.infosec.jce.provider.JCEKeyGenerator;
import cn.com.infosec.jce.provider.JDKAlgorithmParameterGenerator;
import cn.com.infosec.jce.provider.JDKAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class Noekeon {
    private Noekeon() {
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("Noekeon", "INFOSEC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "Noekeon IV";
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new NoekeonEngine());
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("Noekeon", 128, new CipherKeyGenerator());
        }
    }
}

