/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.engines;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.DataLengthException;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.params.ParametersWithSBox;
import cn.com.infosec.util.Strings;
import java.util.Hashtable;

public class GOST28147Engine
implements BlockCipher {
    protected static final int BLOCK_SIZE = 8;
    private int[] workingKey = null;
    private boolean forEncryption;
    private byte[] S;
    private static byte[] ESbox_Test;
    private static byte[] ESbox_A;
    private static byte[] ESbox_B;
    private static byte[] ESbox_C;
    private static byte[] ESbox_D;
    private static byte[] DSbox_Test;
    private static byte[] DSbox_A;
    private static Hashtable sBoxes;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 4;
        byArray[1] = 2;
        byArray[2] = 15;
        byArray[3] = 5;
        byArray[4] = 9;
        byArray[5] = 1;
        byArray[7] = 8;
        byArray[8] = 14;
        byArray[9] = 3;
        byArray[10] = 11;
        byArray[11] = 12;
        byArray[12] = 13;
        byArray[13] = 7;
        byArray[14] = 10;
        byArray[15] = 6;
        byArray[16] = 12;
        byArray[17] = 9;
        byArray[18] = 15;
        byArray[19] = 14;
        byArray[20] = 8;
        byArray[21] = 1;
        byArray[22] = 3;
        byArray[23] = 10;
        byArray[24] = 2;
        byArray[25] = 7;
        byArray[26] = 4;
        byArray[27] = 13;
        byArray[28] = 6;
        byArray[30] = 11;
        byArray[31] = 5;
        byArray[32] = 13;
        byArray[33] = 8;
        byArray[34] = 14;
        byArray[35] = 12;
        byArray[36] = 7;
        byArray[37] = 3;
        byArray[38] = 9;
        byArray[39] = 10;
        byArray[40] = 1;
        byArray[41] = 5;
        byArray[42] = 2;
        byArray[43] = 4;
        byArray[44] = 6;
        byArray[45] = 15;
        byArray[47] = 11;
        byArray[48] = 14;
        byArray[49] = 9;
        byArray[50] = 11;
        byArray[51] = 2;
        byArray[52] = 5;
        byArray[53] = 15;
        byArray[54] = 7;
        byArray[55] = 1;
        byArray[57] = 13;
        byArray[58] = 12;
        byArray[59] = 6;
        byArray[60] = 10;
        byArray[61] = 4;
        byArray[62] = 3;
        byArray[63] = 8;
        byArray[64] = 3;
        byArray[65] = 14;
        byArray[66] = 5;
        byArray[67] = 9;
        byArray[68] = 6;
        byArray[69] = 8;
        byArray[71] = 13;
        byArray[72] = 10;
        byArray[73] = 11;
        byArray[74] = 7;
        byArray[75] = 12;
        byArray[76] = 2;
        byArray[77] = 1;
        byArray[78] = 15;
        byArray[79] = 4;
        byArray[80] = 8;
        byArray[81] = 15;
        byArray[82] = 6;
        byArray[83] = 11;
        byArray[84] = 1;
        byArray[85] = 9;
        byArray[86] = 12;
        byArray[87] = 5;
        byArray[88] = 13;
        byArray[89] = 3;
        byArray[90] = 7;
        byArray[91] = 10;
        byArray[93] = 14;
        byArray[94] = 2;
        byArray[95] = 4;
        byArray[96] = 9;
        byArray[97] = 11;
        byArray[98] = 12;
        byArray[100] = 3;
        byArray[101] = 6;
        byArray[102] = 7;
        byArray[103] = 5;
        byArray[104] = 4;
        byArray[105] = 8;
        byArray[106] = 14;
        byArray[107] = 15;
        byArray[108] = 1;
        byArray[109] = 10;
        byArray[110] = 2;
        byArray[111] = 13;
        byArray[112] = 12;
        byArray[113] = 6;
        byArray[114] = 5;
        byArray[115] = 2;
        byArray[116] = 11;
        byArray[118] = 9;
        byArray[119] = 13;
        byArray[120] = 3;
        byArray[121] = 14;
        byArray[122] = 7;
        byArray[123] = 10;
        byArray[124] = 15;
        byArray[125] = 4;
        byArray[126] = 1;
        byArray[127] = 8;
        ESbox_Test = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[0] = 9;
        byArray2[1] = 6;
        byArray2[2] = 3;
        byArray2[3] = 2;
        byArray2[4] = 8;
        byArray2[5] = 11;
        byArray2[6] = 1;
        byArray2[7] = 7;
        byArray2[8] = 10;
        byArray2[9] = 4;
        byArray2[10] = 14;
        byArray2[11] = 15;
        byArray2[12] = 12;
        byArray2[14] = 13;
        byArray2[15] = 5;
        byArray2[16] = 3;
        byArray2[17] = 7;
        byArray2[18] = 14;
        byArray2[19] = 9;
        byArray2[20] = 8;
        byArray2[21] = 10;
        byArray2[22] = 15;
        byArray2[24] = 5;
        byArray2[25] = 2;
        byArray2[26] = 6;
        byArray2[27] = 12;
        byArray2[28] = 11;
        byArray2[29] = 4;
        byArray2[30] = 13;
        byArray2[31] = 1;
        byArray2[32] = 14;
        byArray2[33] = 4;
        byArray2[34] = 6;
        byArray2[35] = 2;
        byArray2[36] = 11;
        byArray2[37] = 3;
        byArray2[38] = 13;
        byArray2[39] = 8;
        byArray2[40] = 12;
        byArray2[41] = 15;
        byArray2[42] = 5;
        byArray2[43] = 10;
        byArray2[45] = 7;
        byArray2[46] = 1;
        byArray2[47] = 9;
        byArray2[48] = 14;
        byArray2[49] = 7;
        byArray2[50] = 10;
        byArray2[51] = 12;
        byArray2[52] = 13;
        byArray2[53] = 1;
        byArray2[54] = 3;
        byArray2[55] = 9;
        byArray2[57] = 2;
        byArray2[58] = 11;
        byArray2[59] = 4;
        byArray2[60] = 15;
        byArray2[61] = 8;
        byArray2[62] = 5;
        byArray2[63] = 6;
        byArray2[64] = 11;
        byArray2[65] = 5;
        byArray2[66] = 1;
        byArray2[67] = 9;
        byArray2[68] = 8;
        byArray2[69] = 13;
        byArray2[70] = 15;
        byArray2[72] = 14;
        byArray2[73] = 4;
        byArray2[74] = 2;
        byArray2[75] = 3;
        byArray2[76] = 12;
        byArray2[77] = 7;
        byArray2[78] = 10;
        byArray2[79] = 6;
        byArray2[80] = 3;
        byArray2[81] = 10;
        byArray2[82] = 13;
        byArray2[83] = 12;
        byArray2[84] = 1;
        byArray2[85] = 2;
        byArray2[87] = 11;
        byArray2[88] = 7;
        byArray2[89] = 5;
        byArray2[90] = 9;
        byArray2[91] = 4;
        byArray2[92] = 8;
        byArray2[93] = 15;
        byArray2[94] = 14;
        byArray2[95] = 6;
        byArray2[96] = 1;
        byArray2[97] = 13;
        byArray2[98] = 2;
        byArray2[99] = 9;
        byArray2[100] = 7;
        byArray2[101] = 10;
        byArray2[102] = 6;
        byArray2[104] = 8;
        byArray2[105] = 12;
        byArray2[106] = 4;
        byArray2[107] = 5;
        byArray2[108] = 15;
        byArray2[109] = 3;
        byArray2[110] = 11;
        byArray2[111] = 14;
        byArray2[112] = 11;
        byArray2[113] = 10;
        byArray2[114] = 15;
        byArray2[115] = 5;
        byArray2[117] = 12;
        byArray2[118] = 14;
        byArray2[119] = 8;
        byArray2[120] = 6;
        byArray2[121] = 2;
        byArray2[122] = 3;
        byArray2[123] = 9;
        byArray2[124] = 1;
        byArray2[125] = 7;
        byArray2[126] = 13;
        byArray2[127] = 4;
        ESbox_A = byArray2;
        byte[] byArray3 = new byte[128];
        byArray3[0] = 8;
        byArray3[1] = 4;
        byArray3[2] = 11;
        byArray3[3] = 1;
        byArray3[4] = 3;
        byArray3[5] = 5;
        byArray3[7] = 9;
        byArray3[8] = 2;
        byArray3[9] = 14;
        byArray3[10] = 10;
        byArray3[11] = 12;
        byArray3[12] = 13;
        byArray3[13] = 6;
        byArray3[14] = 7;
        byArray3[15] = 15;
        byArray3[17] = 1;
        byArray3[18] = 2;
        byArray3[19] = 10;
        byArray3[20] = 4;
        byArray3[21] = 13;
        byArray3[22] = 5;
        byArray3[23] = 12;
        byArray3[24] = 9;
        byArray3[25] = 7;
        byArray3[26] = 3;
        byArray3[27] = 15;
        byArray3[28] = 11;
        byArray3[29] = 8;
        byArray3[30] = 6;
        byArray3[31] = 14;
        byArray3[32] = 14;
        byArray3[33] = 12;
        byArray3[35] = 10;
        byArray3[36] = 9;
        byArray3[37] = 2;
        byArray3[38] = 13;
        byArray3[39] = 11;
        byArray3[40] = 7;
        byArray3[41] = 5;
        byArray3[42] = 8;
        byArray3[43] = 15;
        byArray3[44] = 3;
        byArray3[45] = 6;
        byArray3[46] = 1;
        byArray3[47] = 4;
        byArray3[48] = 7;
        byArray3[49] = 5;
        byArray3[51] = 13;
        byArray3[52] = 11;
        byArray3[53] = 6;
        byArray3[54] = 1;
        byArray3[55] = 2;
        byArray3[56] = 3;
        byArray3[57] = 10;
        byArray3[58] = 12;
        byArray3[59] = 15;
        byArray3[60] = 4;
        byArray3[61] = 14;
        byArray3[62] = 9;
        byArray3[63] = 8;
        byArray3[64] = 2;
        byArray3[65] = 7;
        byArray3[66] = 12;
        byArray3[67] = 15;
        byArray3[68] = 9;
        byArray3[69] = 5;
        byArray3[70] = 10;
        byArray3[71] = 11;
        byArray3[72] = 1;
        byArray3[73] = 4;
        byArray3[75] = 13;
        byArray3[76] = 6;
        byArray3[77] = 8;
        byArray3[78] = 14;
        byArray3[79] = 3;
        byArray3[80] = 8;
        byArray3[81] = 3;
        byArray3[82] = 2;
        byArray3[83] = 6;
        byArray3[84] = 4;
        byArray3[85] = 13;
        byArray3[86] = 14;
        byArray3[87] = 11;
        byArray3[88] = 12;
        byArray3[89] = 1;
        byArray3[90] = 7;
        byArray3[91] = 15;
        byArray3[92] = 10;
        byArray3[94] = 9;
        byArray3[95] = 5;
        byArray3[96] = 5;
        byArray3[97] = 2;
        byArray3[98] = 10;
        byArray3[99] = 11;
        byArray3[100] = 9;
        byArray3[101] = 1;
        byArray3[102] = 12;
        byArray3[103] = 3;
        byArray3[104] = 7;
        byArray3[105] = 4;
        byArray3[106] = 13;
        byArray3[108] = 6;
        byArray3[109] = 15;
        byArray3[110] = 8;
        byArray3[111] = 14;
        byArray3[113] = 4;
        byArray3[114] = 11;
        byArray3[115] = 14;
        byArray3[116] = 8;
        byArray3[117] = 3;
        byArray3[118] = 7;
        byArray3[119] = 1;
        byArray3[120] = 10;
        byArray3[121] = 2;
        byArray3[122] = 9;
        byArray3[123] = 6;
        byArray3[124] = 15;
        byArray3[125] = 13;
        byArray3[126] = 5;
        byArray3[127] = 12;
        ESbox_B = byArray3;
        byte[] byArray4 = new byte[128];
        byArray4[0] = 1;
        byArray4[1] = 11;
        byArray4[2] = 12;
        byArray4[3] = 2;
        byArray4[4] = 9;
        byArray4[5] = 13;
        byArray4[7] = 15;
        byArray4[8] = 4;
        byArray4[9] = 5;
        byArray4[10] = 8;
        byArray4[11] = 14;
        byArray4[12] = 10;
        byArray4[13] = 7;
        byArray4[14] = 6;
        byArray4[15] = 3;
        byArray4[17] = 1;
        byArray4[18] = 7;
        byArray4[19] = 13;
        byArray4[20] = 11;
        byArray4[21] = 4;
        byArray4[22] = 5;
        byArray4[23] = 2;
        byArray4[24] = 8;
        byArray4[25] = 14;
        byArray4[26] = 15;
        byArray4[27] = 12;
        byArray4[28] = 9;
        byArray4[29] = 10;
        byArray4[30] = 6;
        byArray4[31] = 3;
        byArray4[32] = 8;
        byArray4[33] = 2;
        byArray4[34] = 5;
        byArray4[36] = 4;
        byArray4[37] = 9;
        byArray4[38] = 15;
        byArray4[39] = 10;
        byArray4[40] = 3;
        byArray4[41] = 7;
        byArray4[42] = 12;
        byArray4[43] = 13;
        byArray4[44] = 6;
        byArray4[45] = 14;
        byArray4[46] = 1;
        byArray4[47] = 11;
        byArray4[48] = 3;
        byArray4[49] = 6;
        byArray4[51] = 1;
        byArray4[52] = 5;
        byArray4[53] = 13;
        byArray4[54] = 10;
        byArray4[55] = 8;
        byArray4[56] = 11;
        byArray4[57] = 2;
        byArray4[58] = 9;
        byArray4[59] = 7;
        byArray4[60] = 14;
        byArray4[61] = 15;
        byArray4[62] = 12;
        byArray4[63] = 4;
        byArray4[64] = 8;
        byArray4[65] = 13;
        byArray4[66] = 11;
        byArray4[68] = 4;
        byArray4[69] = 5;
        byArray4[70] = 1;
        byArray4[71] = 2;
        byArray4[72] = 9;
        byArray4[73] = 3;
        byArray4[74] = 12;
        byArray4[75] = 14;
        byArray4[76] = 6;
        byArray4[77] = 15;
        byArray4[78] = 10;
        byArray4[79] = 7;
        byArray4[80] = 12;
        byArray4[81] = 9;
        byArray4[82] = 11;
        byArray4[83] = 1;
        byArray4[84] = 8;
        byArray4[85] = 14;
        byArray4[86] = 2;
        byArray4[87] = 4;
        byArray4[88] = 7;
        byArray4[89] = 3;
        byArray4[90] = 6;
        byArray4[91] = 5;
        byArray4[92] = 10;
        byArray4[94] = 15;
        byArray4[95] = 13;
        byArray4[96] = 10;
        byArray4[97] = 9;
        byArray4[98] = 6;
        byArray4[99] = 8;
        byArray4[100] = 13;
        byArray4[101] = 14;
        byArray4[102] = 2;
        byArray4[104] = 15;
        byArray4[105] = 3;
        byArray4[106] = 5;
        byArray4[107] = 11;
        byArray4[108] = 4;
        byArray4[109] = 1;
        byArray4[110] = 12;
        byArray4[111] = 7;
        byArray4[112] = 7;
        byArray4[113] = 4;
        byArray4[115] = 5;
        byArray4[116] = 10;
        byArray4[117] = 2;
        byArray4[118] = 15;
        byArray4[119] = 14;
        byArray4[120] = 12;
        byArray4[121] = 6;
        byArray4[122] = 1;
        byArray4[123] = 11;
        byArray4[124] = 13;
        byArray4[125] = 9;
        byArray4[126] = 3;
        byArray4[127] = 8;
        ESbox_C = byArray4;
        byte[] byArray5 = new byte[128];
        byArray5[0] = 15;
        byArray5[1] = 12;
        byArray5[2] = 2;
        byArray5[3] = 10;
        byArray5[4] = 6;
        byArray5[5] = 4;
        byArray5[6] = 5;
        byArray5[8] = 7;
        byArray5[9] = 9;
        byArray5[10] = 14;
        byArray5[11] = 13;
        byArray5[12] = 1;
        byArray5[13] = 11;
        byArray5[14] = 8;
        byArray5[15] = 3;
        byArray5[16] = 11;
        byArray5[17] = 6;
        byArray5[18] = 3;
        byArray5[19] = 4;
        byArray5[20] = 12;
        byArray5[21] = 15;
        byArray5[22] = 14;
        byArray5[23] = 2;
        byArray5[24] = 7;
        byArray5[25] = 13;
        byArray5[26] = 8;
        byArray5[28] = 5;
        byArray5[29] = 10;
        byArray5[30] = 9;
        byArray5[31] = 1;
        byArray5[32] = 1;
        byArray5[33] = 12;
        byArray5[34] = 11;
        byArray5[36] = 15;
        byArray5[37] = 14;
        byArray5[38] = 6;
        byArray5[39] = 5;
        byArray5[40] = 10;
        byArray5[41] = 13;
        byArray5[42] = 4;
        byArray5[43] = 8;
        byArray5[44] = 9;
        byArray5[45] = 3;
        byArray5[46] = 7;
        byArray5[47] = 2;
        byArray5[48] = 1;
        byArray5[49] = 5;
        byArray5[50] = 14;
        byArray5[51] = 12;
        byArray5[52] = 10;
        byArray5[53] = 7;
        byArray5[55] = 13;
        byArray5[56] = 6;
        byArray5[57] = 2;
        byArray5[58] = 11;
        byArray5[59] = 4;
        byArray5[60] = 9;
        byArray5[61] = 3;
        byArray5[62] = 15;
        byArray5[63] = 8;
        byArray5[65] = 12;
        byArray5[66] = 8;
        byArray5[67] = 9;
        byArray5[68] = 13;
        byArray5[69] = 2;
        byArray5[70] = 10;
        byArray5[71] = 11;
        byArray5[72] = 7;
        byArray5[73] = 3;
        byArray5[74] = 6;
        byArray5[75] = 5;
        byArray5[76] = 4;
        byArray5[77] = 14;
        byArray5[78] = 15;
        byArray5[79] = 1;
        byArray5[80] = 8;
        byArray5[82] = 15;
        byArray5[83] = 3;
        byArray5[84] = 2;
        byArray5[85] = 5;
        byArray5[86] = 14;
        byArray5[87] = 11;
        byArray5[88] = 1;
        byArray5[89] = 10;
        byArray5[90] = 4;
        byArray5[91] = 7;
        byArray5[92] = 12;
        byArray5[93] = 9;
        byArray5[94] = 13;
        byArray5[95] = 6;
        byArray5[96] = 3;
        byArray5[98] = 6;
        byArray5[99] = 15;
        byArray5[100] = 1;
        byArray5[101] = 14;
        byArray5[102] = 9;
        byArray5[103] = 2;
        byArray5[104] = 13;
        byArray5[105] = 8;
        byArray5[106] = 12;
        byArray5[107] = 4;
        byArray5[108] = 11;
        byArray5[109] = 10;
        byArray5[110] = 5;
        byArray5[111] = 7;
        byArray5[112] = 1;
        byArray5[113] = 10;
        byArray5[114] = 6;
        byArray5[115] = 8;
        byArray5[116] = 15;
        byArray5[117] = 11;
        byArray5[119] = 4;
        byArray5[120] = 12;
        byArray5[121] = 3;
        byArray5[122] = 5;
        byArray5[123] = 9;
        byArray5[124] = 7;
        byArray5[125] = 13;
        byArray5[126] = 2;
        byArray5[127] = 14;
        ESbox_D = byArray5;
        byte[] byArray6 = new byte[128];
        byArray6[0] = 4;
        byArray6[1] = 10;
        byArray6[2] = 9;
        byArray6[3] = 2;
        byArray6[4] = 13;
        byArray6[5] = 8;
        byArray6[7] = 14;
        byArray6[8] = 6;
        byArray6[9] = 11;
        byArray6[10] = 1;
        byArray6[11] = 12;
        byArray6[12] = 7;
        byArray6[13] = 15;
        byArray6[14] = 5;
        byArray6[15] = 3;
        byArray6[16] = 14;
        byArray6[17] = 11;
        byArray6[18] = 4;
        byArray6[19] = 12;
        byArray6[20] = 6;
        byArray6[21] = 13;
        byArray6[22] = 15;
        byArray6[23] = 10;
        byArray6[24] = 2;
        byArray6[25] = 3;
        byArray6[26] = 8;
        byArray6[27] = 1;
        byArray6[29] = 7;
        byArray6[30] = 5;
        byArray6[31] = 9;
        byArray6[32] = 5;
        byArray6[33] = 8;
        byArray6[34] = 1;
        byArray6[35] = 13;
        byArray6[36] = 10;
        byArray6[37] = 3;
        byArray6[38] = 4;
        byArray6[39] = 2;
        byArray6[40] = 14;
        byArray6[41] = 15;
        byArray6[42] = 12;
        byArray6[43] = 7;
        byArray6[44] = 6;
        byArray6[46] = 9;
        byArray6[47] = 11;
        byArray6[48] = 7;
        byArray6[49] = 13;
        byArray6[50] = 10;
        byArray6[51] = 1;
        byArray6[53] = 8;
        byArray6[54] = 9;
        byArray6[55] = 15;
        byArray6[56] = 14;
        byArray6[57] = 4;
        byArray6[58] = 6;
        byArray6[59] = 12;
        byArray6[60] = 11;
        byArray6[61] = 2;
        byArray6[62] = 5;
        byArray6[63] = 3;
        byArray6[64] = 6;
        byArray6[65] = 12;
        byArray6[66] = 7;
        byArray6[67] = 1;
        byArray6[68] = 5;
        byArray6[69] = 15;
        byArray6[70] = 13;
        byArray6[71] = 8;
        byArray6[72] = 4;
        byArray6[73] = 10;
        byArray6[74] = 9;
        byArray6[75] = 14;
        byArray6[77] = 3;
        byArray6[78] = 11;
        byArray6[79] = 2;
        byArray6[80] = 4;
        byArray6[81] = 11;
        byArray6[82] = 10;
        byArray6[84] = 7;
        byArray6[85] = 2;
        byArray6[86] = 1;
        byArray6[87] = 13;
        byArray6[88] = 3;
        byArray6[89] = 6;
        byArray6[90] = 8;
        byArray6[91] = 5;
        byArray6[92] = 9;
        byArray6[93] = 12;
        byArray6[94] = 15;
        byArray6[95] = 14;
        byArray6[96] = 13;
        byArray6[97] = 11;
        byArray6[98] = 4;
        byArray6[99] = 1;
        byArray6[100] = 3;
        byArray6[101] = 15;
        byArray6[102] = 5;
        byArray6[103] = 9;
        byArray6[105] = 10;
        byArray6[106] = 14;
        byArray6[107] = 7;
        byArray6[108] = 6;
        byArray6[109] = 8;
        byArray6[110] = 2;
        byArray6[111] = 12;
        byArray6[112] = 1;
        byArray6[113] = 15;
        byArray6[114] = 13;
        byArray6[116] = 5;
        byArray6[117] = 7;
        byArray6[118] = 10;
        byArray6[119] = 4;
        byArray6[120] = 9;
        byArray6[121] = 2;
        byArray6[122] = 3;
        byArray6[123] = 14;
        byArray6[124] = 6;
        byArray6[125] = 11;
        byArray6[126] = 8;
        byArray6[127] = 12;
        DSbox_Test = byArray6;
        byte[] byArray7 = new byte[128];
        byArray7[0] = 10;
        byArray7[1] = 4;
        byArray7[2] = 5;
        byArray7[3] = 6;
        byArray7[4] = 8;
        byArray7[5] = 1;
        byArray7[6] = 3;
        byArray7[7] = 7;
        byArray7[8] = 13;
        byArray7[9] = 12;
        byArray7[10] = 14;
        byArray7[12] = 9;
        byArray7[13] = 2;
        byArray7[14] = 11;
        byArray7[15] = 15;
        byArray7[16] = 5;
        byArray7[17] = 15;
        byArray7[18] = 4;
        byArray7[20] = 2;
        byArray7[21] = 13;
        byArray7[22] = 11;
        byArray7[23] = 9;
        byArray7[24] = 1;
        byArray7[25] = 7;
        byArray7[26] = 6;
        byArray7[27] = 3;
        byArray7[28] = 12;
        byArray7[29] = 14;
        byArray7[30] = 10;
        byArray7[31] = 8;
        byArray7[32] = 7;
        byArray7[33] = 15;
        byArray7[34] = 12;
        byArray7[35] = 14;
        byArray7[36] = 9;
        byArray7[37] = 4;
        byArray7[38] = 1;
        byArray7[40] = 3;
        byArray7[41] = 11;
        byArray7[42] = 5;
        byArray7[43] = 2;
        byArray7[44] = 6;
        byArray7[45] = 10;
        byArray7[46] = 8;
        byArray7[47] = 13;
        byArray7[48] = 4;
        byArray7[49] = 10;
        byArray7[50] = 7;
        byArray7[51] = 12;
        byArray7[53] = 15;
        byArray7[54] = 2;
        byArray7[55] = 8;
        byArray7[56] = 14;
        byArray7[57] = 1;
        byArray7[58] = 6;
        byArray7[59] = 5;
        byArray7[60] = 13;
        byArray7[61] = 11;
        byArray7[62] = 9;
        byArray7[63] = 3;
        byArray7[64] = 7;
        byArray7[65] = 6;
        byArray7[66] = 4;
        byArray7[67] = 11;
        byArray7[68] = 9;
        byArray7[69] = 12;
        byArray7[70] = 2;
        byArray7[71] = 10;
        byArray7[72] = 1;
        byArray7[73] = 8;
        byArray7[75] = 14;
        byArray7[76] = 15;
        byArray7[77] = 13;
        byArray7[78] = 3;
        byArray7[79] = 5;
        byArray7[80] = 7;
        byArray7[81] = 6;
        byArray7[82] = 2;
        byArray7[83] = 4;
        byArray7[84] = 13;
        byArray7[85] = 9;
        byArray7[86] = 15;
        byArray7[88] = 10;
        byArray7[89] = 1;
        byArray7[90] = 5;
        byArray7[91] = 11;
        byArray7[92] = 8;
        byArray7[93] = 14;
        byArray7[94] = 12;
        byArray7[95] = 3;
        byArray7[96] = 13;
        byArray7[97] = 14;
        byArray7[98] = 4;
        byArray7[99] = 1;
        byArray7[100] = 7;
        byArray7[102] = 5;
        byArray7[103] = 10;
        byArray7[104] = 3;
        byArray7[105] = 12;
        byArray7[106] = 8;
        byArray7[107] = 15;
        byArray7[108] = 6;
        byArray7[109] = 2;
        byArray7[110] = 9;
        byArray7[111] = 11;
        byArray7[112] = 1;
        byArray7[113] = 3;
        byArray7[114] = 10;
        byArray7[115] = 9;
        byArray7[116] = 5;
        byArray7[117] = 11;
        byArray7[118] = 4;
        byArray7[119] = 15;
        byArray7[120] = 8;
        byArray7[121] = 6;
        byArray7[122] = 7;
        byArray7[123] = 14;
        byArray7[124] = 13;
        byArray7[126] = 2;
        byArray7[127] = 12;
        DSbox_A = byArray7;
        sBoxes = new Hashtable();
        sBoxes.put("E-TEST", ESbox_Test);
        sBoxes.put("E-A", ESbox_A);
        sBoxes.put("E-B", ESbox_B);
        sBoxes.put("E-C", ESbox_C);
        sBoxes.put("E-D", ESbox_D);
        sBoxes.put("D-TEST", DSbox_Test);
        sBoxes.put("D-A", DSbox_A);
    }

    public GOST28147Engine() {
        byte[] byArray = new byte[128];
        byArray[0] = 4;
        byArray[1] = 10;
        byArray[2] = 9;
        byArray[3] = 2;
        byArray[4] = 13;
        byArray[5] = 8;
        byArray[7] = 14;
        byArray[8] = 6;
        byArray[9] = 11;
        byArray[10] = 1;
        byArray[11] = 12;
        byArray[12] = 7;
        byArray[13] = 15;
        byArray[14] = 5;
        byArray[15] = 3;
        byArray[16] = 14;
        byArray[17] = 11;
        byArray[18] = 4;
        byArray[19] = 12;
        byArray[20] = 6;
        byArray[21] = 13;
        byArray[22] = 15;
        byArray[23] = 10;
        byArray[24] = 2;
        byArray[25] = 3;
        byArray[26] = 8;
        byArray[27] = 1;
        byArray[29] = 7;
        byArray[30] = 5;
        byArray[31] = 9;
        byArray[32] = 5;
        byArray[33] = 8;
        byArray[34] = 1;
        byArray[35] = 13;
        byArray[36] = 10;
        byArray[37] = 3;
        byArray[38] = 4;
        byArray[39] = 2;
        byArray[40] = 14;
        byArray[41] = 15;
        byArray[42] = 12;
        byArray[43] = 7;
        byArray[44] = 6;
        byArray[46] = 9;
        byArray[47] = 11;
        byArray[48] = 7;
        byArray[49] = 13;
        byArray[50] = 10;
        byArray[51] = 1;
        byArray[53] = 8;
        byArray[54] = 9;
        byArray[55] = 15;
        byArray[56] = 14;
        byArray[57] = 4;
        byArray[58] = 6;
        byArray[59] = 12;
        byArray[60] = 11;
        byArray[61] = 2;
        byArray[62] = 5;
        byArray[63] = 3;
        byArray[64] = 6;
        byArray[65] = 12;
        byArray[66] = 7;
        byArray[67] = 1;
        byArray[68] = 5;
        byArray[69] = 15;
        byArray[70] = 13;
        byArray[71] = 8;
        byArray[72] = 4;
        byArray[73] = 10;
        byArray[74] = 9;
        byArray[75] = 14;
        byArray[77] = 3;
        byArray[78] = 11;
        byArray[79] = 2;
        byArray[80] = 4;
        byArray[81] = 11;
        byArray[82] = 10;
        byArray[84] = 7;
        byArray[85] = 2;
        byArray[86] = 1;
        byArray[87] = 13;
        byArray[88] = 3;
        byArray[89] = 6;
        byArray[90] = 8;
        byArray[91] = 5;
        byArray[92] = 9;
        byArray[93] = 12;
        byArray[94] = 15;
        byArray[95] = 14;
        byArray[96] = 13;
        byArray[97] = 11;
        byArray[98] = 4;
        byArray[99] = 1;
        byArray[100] = 3;
        byArray[101] = 15;
        byArray[102] = 5;
        byArray[103] = 9;
        byArray[105] = 10;
        byArray[106] = 14;
        byArray[107] = 7;
        byArray[108] = 6;
        byArray[109] = 8;
        byArray[110] = 2;
        byArray[111] = 12;
        byArray[112] = 1;
        byArray[113] = 15;
        byArray[114] = 13;
        byArray[116] = 5;
        byArray[117] = 7;
        byArray[118] = 10;
        byArray[119] = 4;
        byArray[120] = 9;
        byArray[121] = 2;
        byArray[122] = 3;
        byArray[123] = 14;
        byArray[124] = 6;
        byArray[125] = 11;
        byArray[126] = 8;
        byArray[127] = 12;
        this.S = byArray;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        if (params instanceof ParametersWithSBox) {
            ParametersWithSBox param = (ParametersWithSBox)params;
            System.arraycopy(param.getSBox(), 0, this.S, 0, param.getSBox().length);
            if (param.getParameters() != null) {
                this.workingKey = this.generateWorkingKey(forEncryption, ((KeyParameter)param.getParameters()).getKey());
            }
        } else if (params instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(forEncryption, ((KeyParameter)params).getKey());
        } else {
            throw new IllegalArgumentException("invalid parameter passed to GOST28147 init - " + params.getClass().getName());
        }
    }

    public String getAlgorithmName() {
        return "GOST28147";
    }

    public int getBlockSize() {
        return 8;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.workingKey == null) {
            throw new IllegalStateException("GOST28147 engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        this.GOST28147Func(this.workingKey, in, inOff, out, outOff);
        return 8;
    }

    public void reset() {
    }

    private int[] generateWorkingKey(boolean forEncryption, byte[] userKey) {
        this.forEncryption = forEncryption;
        if (userKey.length != 32) {
            throw new IllegalArgumentException("Key length invalid. Key needs to be 32 byte - 256 bit!!!");
        }
        int[] key = new int[8];
        int i = 0;
        while (i != 8) {
            key[i] = this.bytesToint(userKey, i * 4);
            ++i;
        }
        return key;
    }

    private int GOST28147_mainStep(int n1, int key) {
        int cm = key + n1;
        int om = this.S[0 + (cm >> 0 & 0xF)] << 0;
        om += this.S[16 + (cm >> 4 & 0xF)] << 4;
        om += this.S[32 + (cm >> 8 & 0xF)] << 8;
        om += this.S[48 + (cm >> 12 & 0xF)] << 12;
        om += this.S[64 + (cm >> 16 & 0xF)] << 16;
        om += this.S[80 + (cm >> 20 & 0xF)] << 20;
        om += this.S[96 + (cm >> 24 & 0xF)] << 24;
        return (om += this.S[112 + (cm >> 28 & 0xF)] << 28) << 11 | om >>> 21;
    }

    private void GOST28147Func(int[] workingKey, byte[] in, int inOff, byte[] out, int outOff) {
        int N1 = this.bytesToint(in, inOff);
        int N2 = this.bytesToint(in, inOff + 4);
        if (this.forEncryption) {
            int tmp;
            int k = 0;
            while (k < 3) {
                int j = 0;
                while (j < 8) {
                    tmp = N1;
                    N1 = N2 ^ this.GOST28147_mainStep(N1, workingKey[j]);
                    N2 = tmp;
                    ++j;
                }
                ++k;
            }
            int j = 7;
            while (j > 0) {
                tmp = N1;
                N1 = N2 ^ this.GOST28147_mainStep(N1, workingKey[j]);
                N2 = tmp;
                --j;
            }
        } else {
            int tmp;
            int j = 0;
            while (j < 8) {
                tmp = N1;
                N1 = N2 ^ this.GOST28147_mainStep(N1, workingKey[j]);
                N2 = tmp;
                ++j;
            }
            int k = 0;
            while (k < 3) {
                int j2 = 7;
                while (j2 >= 0) {
                    if (k == 2 && j2 == 0) break;
                    tmp = N1;
                    N1 = N2 ^ this.GOST28147_mainStep(N1, workingKey[j2]);
                    N2 = tmp;
                    --j2;
                }
                ++k;
            }
        }
        this.intTobytes(N1, out, outOff);
        this.intTobytes(N2 ^= this.GOST28147_mainStep(N1, workingKey[0]), out, outOff + 4);
    }

    private int bytesToint(byte[] in, int inOff) {
        return (in[inOff + 3] << 24 & 0xFF000000) + (in[inOff + 2] << 16 & 0xFF0000) + (in[inOff + 1] << 8 & 0xFF00) + (in[inOff] & 0xFF);
    }

    private void intTobytes(int num, byte[] out, int outOff) {
        out[outOff + 3] = (byte)(num >>> 24);
        out[outOff + 2] = (byte)(num >>> 16);
        out[outOff + 1] = (byte)(num >>> 8);
        out[outOff] = (byte)num;
    }

    public static byte[] getSBox(String sBoxName) {
        byte[] namedSBox = (byte[])sBoxes.get(Strings.toUpperCase(sBoxName));
        if (namedSBox != null) {
            byte[] sBox = new byte[namedSBox.length];
            System.arraycopy(namedSBox, 0, sBox, 0, sBox.length);
            return sBox;
        }
        throw new IllegalArgumentException("Unknown S-Box - possible types: \"E-Test\", \"E-A\", \"E-B\", \"E-C\", \"E-D\", \"D-Test\", \"D-A\".");
    }
}

