/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.agent.NetSignAgent;
import java.io.FileInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class TestRaw
implements Runnable {
    private NetSignAgent nsa;
    private int count;
    private String issign;
    private X509Certificate cert;
    private Thread t;

    public TestRaw(int count, String issign) {
        try {
            this.nsa = new NetSignAgent();
            NetSignAgent.initialize();
            this.count = count;
            this.issign = issign;
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            this.cert = (X509Certificate)cf.generateCertificate(new FileInputStream("/opt/infosec/NetSignServer20/NetSignServer/cert/dacert/threecert.cer"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        try {
            int i = 0;
            while (i < this.count) {
                if (this.issign.equals("true")) {
                    NetSignAgent.rawSignature("111111".getBytes(), null, false);
                } else {
                    String plaintext = "111111";
                    String cryptotext = "m7tBCE43pcWon3wyRdlS9H35hk9b74L/ajyQRi1aZPnbkPYg5RJJV2HPwCXOxcA5kVb8cFMslcHHTedqFwBdliSyfnkqUMbT0JkO26MnCvzUegbPVeVBqLj5ArhjyikJTWHBG6JmdjMzvUirxHU29NAmfU3/rnKt8yW7+zQ4Yvc=";
                    NetSignAgent.rawVerify("111111".getBytes(), cryptotext, null, this.cert);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAlive() {
        return this.t.isAlive();
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        Security.addProvider((Provider)new InfosecProvider());
        int times = Integer.parseInt(args[1]);
        int threads = Integer.parseInt(args[2]);
        TestRaw[] trs = new TestRaw[threads];
        int i = 0;
        while (i < threads) {
            trs[i] = new TestRaw(times, args[0]);
            trs[i].start();
            ++i;
        }
        boolean allstop = false;
        while (!allstop) {
            allstop = true;
            int i2 = 0;
            while (i2 < threads) {
                if (trs[i2].isAlive()) {
                    allstop = false;
                }
                ++i2;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        start = System.currentTimeMillis() - start;
        System.out.println(start);
    }
}

