/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.service;

import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.service.NSService;
import java.util.Arrays;

public class ServiceList {
    private NSService[] list = null;
    private Object syncObj = new Object();
    public static final int SERVICE_TYPE_AVAILABLE = 1;
    public static final int SERVICE_TYPE_TOBETEST = 2;
    public static final int SERVICE_TYPE_DEAD = 4;

    public ServiceList() {
    }

    public ServiceList(NSService[] list) {
        this.list = list;
    }

    public NSService get(int i) {
        return this.list[i];
    }

    public int contains(NSService s) {
        if (s == null || s.getIp() == null || s.getPort() <= 0) {
            return -1;
        }
        if (this.list == null || this.list.length == 0 && s != null) {
            return -1;
        }
        int i = 0;
        while (i < this.list.length) {
            try {
                if (this.list[i].equals(s)) {
                    return i;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(NSService s) {
        if (s == null || s.getIp() == null || s.getPort() <= 0) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.list == null) {
                this.list = new NSService[0];
            }
            if (this.contains(s) < 0) {
                NSService[] tmp = new NSService[this.list.length + 1];
                System.arraycopy(this.list, 0, tmp, 0, this.list.length);
                s.setId(tmp.length - 1);
                tmp[tmp.length - 1] = s;
                this.list = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(NSService s) {
        if (s == null || s.getIp() == null || s.getPort() <= 0) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.list == null || this.list.length == 0) {
                return;
            }
            int i = this.contains(s);
            if (i < 0) {
                return;
            }
            NSService[] tmp = new NSService[this.list.length - 1];
            System.arraycopy(this.list, 0, tmp, 0, i);
            System.arraycopy(this.list, i + 1, tmp, i, this.list.length - i - 1);
            this.list = tmp;
        }
    }

    public NSService removeService(int index) {
        if (this.list == null || this.list.length == 0) {
            return null;
        }
        if (index < 0 || this.list.length < index) {
            return null;
        }
        NSService nss = this.list[index];
        NSService[] tmp = new NSService[this.list.length - 1];
        int x = 0;
        int i = 0;
        while (i < this.list.length) {
            if (i != index) {
                tmp[x] = this.list[i];
                ++x;
            }
            ++i;
        }
        return nss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.list == null || this.list.length == 0) {
                return;
            }
            Arrays.sort(this.list);
        }
    }

    public ServiceList getAllServices() {
        if (this.list == null || this.list.length == 0) {
            return null;
        }
        try {
            NSService[] tmp = new NSService[this.list.length];
            System.arraycopy(this.list, 0, tmp, 0, tmp.length);
            return new ServiceList(tmp);
        }
        catch (Exception e) {
            return this.getAllServices();
        }
    }

    public NSService[] toArray() {
        return this.list;
    }

    public ServiceList filter(int type) {
        NSService[] all = this.getAllServices().toArray();
        if (all == null) {
            return null;
        }
        ServiceList l = new ServiceList();
        int i = 0;
        while (i < all.length) {
            if ((type & 1) != 0 && all[i].isAvailable()) {
                l.addService(all[i]);
            }
            if (all[i].getLastTestTime() > System.currentTimeMillis()) {
                all[i].setLastTestTime(0L);
            }
            if ((type & 2) != 0 && !all[i].isAvailable() && System.currentTimeMillis() - all[i].getLastTestTime() >= NetSignAgentRes.getTestInterval()) {
                l.addService(all[i]);
            }
            if ((type & 4) != 0 && !all[i].isAvailable() && System.currentTimeMillis() - all[i].getLastTestTime() < NetSignAgentRes.getTestInterval()) {
                l.addService(all[i]);
            }
            ++i;
        }
        return l;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.length;
    }

    public NSService getService(int i) {
        return this.list[i];
    }

    public String toString() {
        if (this.list == null || this.list.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer("ServiceList:");
        int i = 0;
        int size = this.list.length;
        while (i < size) {
            buf.append("[" + this.list[i].toString() + "]");
            ++i;
        }
        return buf.toString();
    }
}

