/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.crypto.util.Base64;

public class SecurityRandom {
    private byte[] ran;
    private byte[] envelopeRan;
    private byte[] cipherRan;
    private byte isCipher;

    void parse(byte[] ranText) {
        this.isCipher = ranText[0];
        byte[] lengthBs = new byte[4];
        System.arraycopy(ranText, 1, lengthBs, 0, 4);
        int length = Utils.generateInt(lengthBs);
        this.cipherRan = new byte[length];
        System.arraycopy(ranText, 5, this.cipherRan, 0, length);
        lengthBs = new byte[4];
        System.arraycopy(ranText, 5 + this.cipherRan.length, lengthBs, 0, 4);
        length = Utils.generateInt(lengthBs);
        this.envelopeRan = new byte[length];
        System.arraycopy(ranText, 9 + this.cipherRan.length, this.envelopeRan, 0, length);
        if (!this.isCipher()) {
            this.ran = this.cipherRan;
            this.cipherRan = null;
        }
    }

    public boolean isCipher() {
        return this.isCipher == 1;
    }

    public byte[] getRandom() {
        return this.ran;
    }

    public String getHexRandom() {
        return Utils.toHexString(this.ran);
    }

    public byte[] getRandomCipher() {
        return this.cipherRan;
    }

    public byte[] getRandomEnvelope() {
        return this.envelopeRan;
    }

    public String getRandomCipherB64() {
        return Base64.encode(this.cipherRan);
    }

    public String getRandomEnvelopeB64() {
        return Base64.encode(this.envelopeRan);
    }
}

