package com.clx.performance.event;

import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.ApplicationEvent;

@Getter
@Setter
public class SettlementUpdateEvent extends ApplicationEvent {


    private SettlementDriverDetail settlementDriverDetail;

    private SettlementOwnerDetail settlementOwnerDetail;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param source the object on which the event initially occurred or with
     *               which the event is associated (never {@code null})
     */
    public SettlementUpdateEvent(Object source) {
        super(source);
    }

    public SettlementUpdateEvent(Object source, SettlementDriverDetail settlementDriverDetail, SettlementOwnerDetail settlementOwnerDetail) {
        super(source);
        this.settlementDriverDetail = settlementDriverDetail;
        this.settlementOwnerDetail = settlementOwnerDetail;
    }

}
