package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.clx.performance.dao.PerformanceProgressLogDao;
import com.clx.performance.mapper.PerformanceProgressLogMapper;
import com.clx.performance.model.PerformanceProgressLog;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Repository
public class PerformanceProgressLogDaoImpl extends BaseDaoImpl<PerformanceProgressLogMapper, PerformanceProgressLog, Integer> implements PerformanceProgressLogDao {
    @Override
    public List<PerformanceProgressLog> getOperationLog(String orderNo) {
        LambdaQueryWrapper<PerformanceProgressLog> query = new LambdaQueryWrapper<>();
        query.eq(PerformanceProgressLog :: getOrderNo,orderNo);
        query.orderByDesc(PerformanceProgressLog :: getId);
        return baseMapper.selectList(query);
    }
}
