package com.clx.performance.service.impl;


import com.clx.performance.dao.OrderChildPoundLogDao;
import com.clx.performance.model.OrderChildPoundLog;
import com.clx.performance.service.OrderChildPoundLogService;
import com.clx.performance.struct.OrderChildPoundLogStruct;
import com.clx.performance.vo.pc.OrderChildPoundLogVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author liruixin
 * Date 2023-09-19
 * Time 13:25
 */
@Slf4j
@Service
@AllArgsConstructor
public class OrderChildPoundLogServiceImpl  implements OrderChildPoundLogService {

    private final OrderChildPoundLogDao orderChildPoundLogDao;

    private final OrderChildPoundLogStruct orderChildPoundLogStruct;

    @Override
    public List<OrderChildPoundLogVO> getPoundLogList(String childNo) {
        List<OrderChildPoundLog> poundLogList = orderChildPoundLogDao.getPoundLogList(childNo);
        return orderChildPoundLogStruct.convert(poundLogList);
    }

    @Override
    public void saveDriverOrderChildLog(String childNo, Integer status, String remark,Integer createType, Long createBy, String createName) {
        OrderChildPoundLog poundLog = new OrderChildPoundLog();
        poundLog.setChildNo(childNo);
        poundLog.setStatus(status);
        poundLog.setRemark(remark);
        poundLog.setCreateBy(createBy);
        poundLog.setCreateName(createName);
        poundLog.setCreateType(createType);

        orderChildPoundLogDao.saveEntity(poundLog);

    }
}
