package com.clx.performance.feign;

import com.clx.performance.param.feign.transport.*;
import com.msl.common.dto.HttpDTO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@FeignClient(name = "transport-service-yitu", url = "${transport-service.host}", configuration = FeignInterceptor.class)
public interface TransportFeignService {

    /**
     * 运单同步
     */
    @RequestMapping(value = "/transport-service/thirdParty/order/orderChildSync", method = RequestMethod.POST)
    HttpDTO orderChildSync(@RequestBody ThirdOrderChildBrokerParam param);

    /**
     * 获取风控状态
     * @return
     * @see com.clx.performance.param.feign.transport.ThirdOrderChildRiskStatusParam
     */
    @RequestMapping(value = "/transport-service/thirdParty/order/getRiskStatus", method = RequestMethod.POST)
    HttpDTO getRiskStatus(@RequestBody @NotBlank(message = "运单编号不能为空") String childNo);

    /**
     * 运单支付运费同步
     */
    @RequestMapping(value = "/transport-service/thirdParty/order/orderChildPaySync", method = RequestMethod.POST)
    HttpDTO orderChildPaySync(@RequestBody OrderChildPaySyncParam param);

    /**
     * 获取运单开票状态
     * @return 0-未申请，10-已申请，20-审核失败，30-已开票
     */
    @RequestMapping(value = "/transport-service/thirdParty/order/getInvoiceStatus", method = RequestMethod.POST)
    Result<Integer> getInvoiceStatus(@RequestBody @NotBlank(message = "运单编号不能为空") String childNo);

    /**
     * 货主结算单同步 (只推同一货主)
     */
    @RequestMapping(value = "/transport-service/thirdParty/order/ownerSettlementSync", method = RequestMethod.POST)
    HttpDTO ownerSettlementSync(@RequestBody OwnerSettlementSyncParam param);

    /**
     * 货主同步(法人模式)
     * @return 货主用户id
     */
    @RequestMapping(value = "/transport-service/thirdParty/owner/ownerLegalSync", method = RequestMethod.POST)
    Result<Integer> ownerLegalSync(@RequestBody OwnerLegalSyncParam param);

    /**
     * 货主同步(自然人模式)
     * @return 货主用户id
     */
    @RequestMapping(value = "/transport-service/thirdParty/owner/ownerPersonalSync", method = RequestMethod.POST)
    Result<Integer> ownerPersonalSync(@RequestBody OwnerPersonalSyncParam param);

    /**
     * 检测货主是否注册
     * @return 0不存在 1存在
     */
    @RequestMapping(value = "/transport-service/thirdParty/owner/ownerExistCheck", method = RequestMethod.POST)
    Result<Integer> ownerExistCheck(@Validated @NotBlank(message = "手机不能为空") String mobile);

    /**
     * 获取货主用户id
     * @Return null未注册
     */
    @RequestMapping(value = "/transport-service/thirdParty/owner/getOwnerId", method = RequestMethod.POST)
    Result<Integer> getOwnerId(@Validated @NotBlank(message = "手机不能为空") String mobile);

}
