package com.clx.performance.dao.impl.settle;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.NetworkDriverRunningWaterRecordDao;
import com.clx.performance.mapper.settle.NetworkDriverRunningWaterRecordMapper;
import com.clx.performance.model.settle.NetworkDriverRunningWaterRecord;
import com.clx.performance.param.app.NetworkDriverPageParam;
import com.clx.performance.param.pc.PageNetworkAccountInfoListParam;
import com.clx.performance.vo.app.APPNetworkDriverRunningWaterRecordVO;
import com.clx.performance.vo.pc.NetworkDriverRunningWaterRecordVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Repository
public class NetworkDriverRunningWaterRecordDaoImpl extends BaseDaoImpl<NetworkDriverRunningWaterRecordMapper, NetworkDriverRunningWaterRecord, Integer> implements NetworkDriverRunningWaterRecordDao {


    @Override
    public IPage<NetworkDriverRunningWaterRecordVO> networkDriverRunningWaterRecordDao(PageNetworkAccountInfoListParam param) {
        Page<NetworkDriverRunningWaterRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.networkDriverRunningWaterRecordDao(page, param);
    }

    @Override
    public IPage<APPNetworkDriverRunningWaterRecordVO> pageFrozenList(NetworkDriverPageParam param) {
        Page<APPNetworkDriverRunningWaterRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageFrozenList(page, param);
    }

    @Override
    public IPage<APPNetworkDriverRunningWaterRecordVO> runningWaterList(NetworkDriverPageParam param) {
        Page<APPNetworkDriverRunningWaterRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.runningWaterList(page, param);
    }
}
