package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum BreakContractOwnerRecordEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum PayStatus {
        NOT(0, "未缴费"),
        YES(1, "已缴费"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<PayStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(PayStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum CompensationStatusStatus {
        NOT(0, "未赔付"),
        YES(1, "已赔付"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<CompensationStatusStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(CompensationStatusStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum ConfirmStatus {
        CONFIRMING(0, "确认中"),
        CONFIRMED(1, "已确认"),
        REJECT(2, "已驳回"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<ConfirmStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(ConfirmStatus::getMsg).orElse(null);
        }
    }


}
