package com.clx.performance.sqlProvider.loan;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountWaterRecordOfOwnerParam;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountRunningWaterRecordVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class OwnerLoanAccountRunningWaterRecordSqlProvider {

    public String pageByParam(@Param("page") Page<OwnerLoanAccountRunningWaterRecordVO> page, @Param("param") PageOwnerLoanAccountWaterRecordOfOwnerParam param) {
        return new SQL(){{

            SELECT(" id, owner_user_no as ownerUserNo, owner_user_name as ownerUserName, mobile, " +
                    " running_water_no as runningWaterNo, loan_no as loanNo, child_no as childNo, " +
                    " running_water_type as runningWaterType, " +
                    " alteration_balance as alterationBalance, useable_balance as useableBalance, frozen_balance as frozenBalance, account_balance as accountBalance, " +
                    " create_by as createBy, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("owner_loan_account_running_water_record");
            WHERE("owner_user_no = #{param.ownerUserNo}");

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (Objects.nonNull(param.getRunningWaterNo())) {WHERE("running_water_no = #{param.runningWaterNo}");}
            if (Objects.nonNull(param.getRunningWaterType())) {WHERE("running_water_type = #{param.runningWaterType}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
