package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.loan.BorrowerConfigDao;
import com.clx.performance.dao.loan.BorrowerDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.loan.BorrowerConfigEnum;
import com.clx.performance.model.loan.Borrower;
import com.clx.performance.model.loan.BorrowerConfig;
import com.clx.performance.param.pc.loan.carrier.*;
import com.clx.performance.service.loan.BorrowerConfigService;
import com.clx.performance.struct.borrower.BorrowerConfigStruct;
import com.clx.performance.vo.pc.loan.carrier.BorrowerConfigVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 借出方
 * @Date: 2024/01/17 13:42:57
 * @Version: 1.0
 */
@Slf4j
@Service
public class BorrowerConfigServiceImpl implements BorrowerConfigService {

    @Autowired
    private BorrowerDao borrowerDao;

    @Autowired
    private BorrowerConfigDao borrowerConfigDao;

    @Autowired
    private BorrowerConfigStruct borrowerConfigStruct;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBorrowerConfig(BorrowerConfigAddParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        // 重复验证
        Optional<BorrowerConfig> borrowerConfigOptional = borrowerConfigDao.selectByBorrowerIdAndType(param.getBorrowerId(), param.getType());
        if (borrowerConfigOptional.isPresent()) {
            throw new ServiceSystemException(PerformanceResultEnum.BORROWER_CONFIG_BORROWER_ID_EXIST);
        }

        Borrower borrower = borrowerDao.getEntityByKey(param.getBorrowerId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        BorrowerConfig borrowerConfig = new BorrowerConfig();
        borrowerConfig.setBorrowerId(borrower.getId());
        borrowerConfig.setBorrowerName(borrower.getName());
        borrowerConfig.setType(param.getType());
        borrowerConfig.setDay(param.getDay());

        borrowerConfig.setOpUserNo(loginUserInfo.getUserNo());
        borrowerConfig.setOpUserName(loginUserInfo.getUserName());
        borrowerConfig.setOpTime(LocalDateTime.now());
        borrowerConfig.setCreateBy(loginUserInfo.getUserNo());
        borrowerConfig.setCreateName(loginUserInfo.getUserName());

        borrowerConfigDao.saveEntity(borrowerConfig);
    }

    @Override
    public void updateBorrowerConfig(BorrowerConfigUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        BorrowerConfig borrowerConfig = borrowerConfigDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        // 重复验证
        Optional<BorrowerConfig> borrowerConfigOptional = borrowerConfigDao.selectByBorrowerIdAndType(param.getBorrowerId(), param.getType());
        if (borrowerConfigOptional.isPresent() && !Objects.equals(borrowerConfig.getId(), borrowerConfigOptional.get().getId())) {
            throw new ServiceSystemException(PerformanceResultEnum.BORROWER_CONFIG_BORROWER_ID_EXIST);
        }

        Borrower borrower = borrowerDao.getEntityByKey(param.getBorrowerId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        borrowerConfig.setBorrowerId(borrower.getId());
        borrowerConfig.setBorrowerName(borrower.getName());
        borrowerConfig.setType(param.getType());
        borrowerConfig.setDay(param.getDay());

        borrowerConfig.setOpUserNo(loginUserInfo.getUserNo());
        borrowerConfig.setOpUserName(loginUserInfo.getUserName());
        borrowerConfig.setOpTime(LocalDateTime.now());

        borrowerConfigDao.update(borrowerConfig);
    }

    @Override
    public void updateStatus(BorrowerConfigStatusUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        BorrowerConfig borrowerConfig = borrowerConfigDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        borrowerConfig.setStatus(param.getStatus());
        borrowerConfig.setOpUserNo(loginUserInfo.getUserNo());
        borrowerConfig.setOpUserName(loginUserInfo.getUserName());
        borrowerConfig.setOpTime(LocalDateTime.now());
        borrowerConfigDao.updateStatus(borrowerConfig);
    }

    @Override
    public void updateDelete(BorrowerConfigDeleteUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        BorrowerConfig borrowerConfig = borrowerConfigDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if (Objects.equals(borrowerConfig.getStatus(), BorrowerConfigEnum.Status.ENABLE)){
            throw new ServiceSystemException(PerformanceResultEnum.BORROWER_CONFIG_DELETE_ENABLE_ERROR);
        }

        borrowerConfig.setDeleteStatus(BorrowerConfigEnum.DeleteStatus.YES.getCode());
        borrowerConfig.setOpUserNo(loginUserInfo.getUserNo());
        borrowerConfig.setOpUserName(loginUserInfo.getUserName());
        borrowerConfig.setOpTime(LocalDateTime.now());
        borrowerConfigDao.updateDelete(borrowerConfig);
    }

    @Override
    public IPage<BorrowerConfigVO> pageBorrowerConfig(PageBorrowerConfigParam param) {
        return borrowerConfigDao.pageByParam(param);

    }

    @Override
    public List<BorrowerConfigVO> ListBorrowerConfig() {
        return borrowerConfigStruct.convert(borrowerConfigDao.listEnable());
    }

}
