package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_loan_account_running_water_record")
public class OwnerLoanAccountRunningWaterRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    
    @TableField("owner_user_no")
    @ApiModelProperty("货主编码")
    private Long ownerUserNo;

    
    @TableField("owner_user_name")
    @ApiModelProperty("货主名称")
    private String ownerUserName;

    
    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    
    @TableField("running_water_no")
    @ApiModelProperty("流水号")
    private Long runningWaterNo;

    
    @TableField("loan_no")
    @ApiModelProperty("借款单号")
    private Long loanNo;

    
    @TableField("child_no")
    @ApiModelProperty("运单编号")
    private String childNo;

    
    @TableField("running_water_type")
    @ApiModelProperty("流水类型 70：运单核销 80：借款")
    private Integer runningWaterType;

    
    @TableField("alteration_balance")
    @ApiModelProperty("金额")
    private BigDecimal alterationBalance;

    @TableField("useable_balance")
    @ApiModelProperty("可用余额")
    private BigDecimal useableBalance;

    @TableField("frozen_balance")
    @ApiModelProperty("冻结余额")
    private BigDecimal frozenBalance;

    @TableField("account_balance")
    @ApiModelProperty("账户余额")
    private BigDecimal accountBalance;

    
    @TableField("create_by")
    @ApiModelProperty("创建人")
    private String createBy;

    
    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
