package com.clx.performance.dao.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerLoanAccountDao;
import com.clx.performance.mapper.loan.OwnerLoanAccountMapper;
import com.clx.performance.model.loan.OwnerLoanAccount;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerLoanAccountVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.msl.common.utils.DateUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Repository
public class OwnerLoanAccountDaoImpl extends BaseDaoImpl<OwnerLoanAccountMapper, OwnerLoanAccount, Integer> implements OwnerLoanAccountDao {

    @Override
    public Integer updateAccountCAS(OwnerLoanAccount account, LocalDateTime now, boolean flag) {
        String nowStr = DateUtils.formatDateTime(now).get();
        if (flag) {
            return baseMapper.addAccount(account, nowStr);
        } else {
            return baseMapper.subAccount(account, nowStr);
        }
    }

    @Override
    public IPage<CarrierOwnerLoanAccountVO> pageByParam(PageOwnerLoanAccountParam param) {
        Page<CarrierOwnerLoanAccountVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

}
