package com.clx.performance.vo.pc.loan.carrier;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 借款配置
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@ApiModel(description = "借款配置")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BorrowerConfigVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "借出方id", example = "")
    private Integer borrowerId;
    @ApiModelProperty(value = "借出方", example = "")
    private String borrowerName;
    @ApiModelProperty(value = "类型：1资金 2虚拟货币", example = "")
    private Integer type;
    @ApiModelProperty(value = "借款天数", example = "")
    private Integer day;
    @ApiModelProperty(value = "状态：1启用 2禁用", example = "")
    private Integer status;
    @ApiModelProperty(value = "操作人编码", example = "1000")
    private Long opUserNo;
    @ApiModelProperty(value = "操作人", example = "张三")
    private String opUserName;
    @ApiModelProperty(value = "操作时间", example = "")
    private String opTime;
    @ApiModelProperty(value = "创建人编号", example = "1000000")
    private Long createBy;
    @ApiModelProperty(value = "创建人名称", example = "张三")
    private String createName;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;

}