package com.clx.performance.vo.pc;

import com.clx.performance.util.NumberToChineseUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.Arrays;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 积分车辆
* @Date: 2023-10-9 13:36:29
* @Version: 1.0
*/

@ApiModel(description = "积分车辆")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class IntegralTruckVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "车牌号", example = "京A12345")
    private String truckNo;
    @ApiModelProperty(value = "司机姓名", example = "张三")
    private String driverName;
    @ApiModelProperty(value = "司机手机号", example = "13000000000")
    private String driverMobile;

    @ApiModelProperty(value = "梯队", example = "1")
    private Integer echelon;
    @ApiModelProperty(value = "梯队", example = "第一梯队")
    private String echelonMsg;
    public String getEchelonMsg() {
        return echelonMsg = "第"+ NumberToChineseUtil.convertToChinese(echelon)+"梯队";
    }

    @ApiModelProperty(value = "积分", example = "1")
    private Integer integral;
    @ApiModelProperty(value = "排名", example = "1")
    private Integer rank;

    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;

    @ApiModelProperty(value = "运单完成积分", example = "1")
    private Integer orderChildCompleteIntegral=0;
    @ApiModelProperty(value = "平台补偿积分", example = "1")
    private Integer platformCompensationIntegral=0;
    @ApiModelProperty(value = "运单取消积分", example = "1")
    private Integer orderChildCancelIntegral=0;
    @ApiModelProperty(value = "运单超时积分", example = "1")
    private Integer orderChildTimeoutIntegral=0;
    @ApiModelProperty(value = "信息上报积分", example = "1")
    private Integer reportIntegral=0;

    @ApiModelProperty(value = "信息上报积分", example = "1")
    private List<IntegralItem> integralItemList;
    public List<IntegralItem> getIntegralItemList() {
        return Arrays.asList(
                new IntegralItem("运单完成积分", orderChildCompleteIntegral),
                new IntegralItem("平台补偿积分", platformCompensationIntegral),
                new IntegralItem("运单取消扣减", orderChildCancelIntegral),
                new IntegralItem("运单超时扣减", orderChildTimeoutIntegral),
                new IntegralItem("信息上报积分", reportIntegral)
        );
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IntegralItem{
        @ApiModelProperty(value = "名称", example = "1")
        private String name;
        @ApiModelProperty(value = "信息上报积分", example = "1")
        private Integer integral;
    }

}