package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum OwnerLoanAccountRunningWaterRecordEnum {
    ;

    //10：运单核销 20：借款
    @Getter
    @AllArgsConstructor
    public enum RunWaterType {
        APPROVE_WAIT(10, "借款"),
        APPROVE_FROZEN(20, "冻结"),
        APPROVE_CHILD_WRITE_OFF(30, "运单核销"),
        APPROVE_THAW(40, "解冻"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerLoanAccountRunningWaterRecordEnum.RunWaterType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(OwnerLoanAccountRunningWaterRecordEnum.RunWaterType::getMsg).orElse(null);
        }
    }

}
