/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.PKCS7SignedData;
import cn.com.infosec.jce.X509V1CertificateGenerator;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SoftCryptoImpl {
    public static final int SHA1 = 100;
    public static final int MD5 = 101;
    public static final int MD2 = 102;
    public static final int KEY_128 = 128;
    public static final int KEY_192 = 192;
    public static final int KEY_256 = 256;
    public static final int KEY_512 = 512;
    public static final int KEY_1024 = 1024;
    public static final int KEY_2048 = 2048;
    public static final int KEY_4096 = 4096;
    public static int SHA1_WITH_RSA = 200;
    public static final int AES = 300;
    public static final int TRIPLEDESCBC = 301;
    public static int RC4 = 302;
    public static int RSA = 400;
    public static int RSAKeyPair = 500;
    public static final int TRIPLEDES = 501;

    private SoftCryptoImpl() {
    }

    public static byte[] sign(PrivateKey pk, byte[] srcdata, String digestalg, String provider) throws CryptoException {
        try {
            Signature sig = Signature.getInstance(SoftCryptoImpl.getSignatureAlgorithm(digestalg, "RSA"), provider);
            if (sig == null) {
                throw new CryptoException("Sign Error:Signature generator fail");
            }
            sig.initSign(pk);
            sig.update(srcdata, 0, srcdata.length);
            return sig.sign();
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoException("Sign Error :" + e.toString(), e);
        }
    }

    public static byte[] sign(PrivateKey pk, byte[] srcdata, String digestalg) throws CryptoException {
        try {
            Signature sig = Signature.getInstance(SoftCryptoImpl.getSignatureAlgorithm(digestalg, "RSA"), "INFOSEC");
            if (sig == null) {
                throw new CryptoException("Sign Error:Signature generator fail");
            }
            sig.initSign(pk);
            sig.update(srcdata, 0, srcdata.length);
            return sig.sign();
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoException("Sign Error :" + e.toString(), e);
        }
    }

    private static PrivateKey getPrivateKey(String alg, byte[] privKey) throws CryptoException {
        try {
            PKCS8EncodedKeySpec p8 = new PKCS8EncodedKeySpec(privKey);
            KeyFactory kf = KeyFactory.getInstance(alg, "INFOSEC");
            PrivateKey pk = kf.generatePrivate(p8);
            return pk;
        }
        catch (Throwable e) {
            throw new CryptoException("p7Sign Error:Can not convert PrivateKey(Not PrivateKeyInfo) bytearray to Privatekey object :" + e.toString(), e);
        }
    }

    private static String getSignatureAlgorithm(String digestAlgorithm, String digestEncryptionAlgorithm) {
        String da = digestAlgorithm;
        String dea = digestEncryptionAlgorithm;
        String alg = String.valueOf(da) + "with" + dea;
        return alg;
    }

    public static byte[] p7verify(byte[] SignedMessage) throws CryptoException {
        try {
            PKCS7SignedData pkcs7 = new PKCS7SignedData(SignedMessage);
            byte[] plaintext = pkcs7.getContentData();
            pkcs7.update(plaintext, 0, plaintext.length);
            boolean isverify = pkcs7.verify();
            if (!isverify) {
                throw new CryptoException("Can not Verify GssAMessage");
            }
            return plaintext;
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoException("p7verify Error" + e.toString(), e);
        }
    }

    public static byte[] p7sign(byte[] priKey, Certificate[] certChain, byte[] srcdata, boolean isAttached) throws CryptoException {
        try {
            PrivateKey pk = SoftCryptoImpl.getPrivateKey("RSA", priKey);
            PKCS7SignedData pkcs7 = new PKCS7SignedData(pk, certChain, "SHA1");
            pkcs7.update(srcdata, 0, srcdata.length);
            if (isAttached) {
                return pkcs7.getEncoded(srcdata);
            }
            return pkcs7.getEncoded();
        }
        catch (Throwable e) {
            throw new CryptoException("P7Sign Error :" + e.getMessage(), e);
        }
    }

    public static byte[] p7sign(PrivateKey pk, Certificate[] certChain, byte[] srcdata, boolean isAttached) throws CryptoException {
        try {
            PKCS7SignedData pkcs7 = new PKCS7SignedData(pk, certChain, "SHA1");
            pkcs7.update(srcdata, 0, srcdata.length);
            if (isAttached) {
                return pkcs7.getEncoded(srcdata);
            }
            return pkcs7.getEncoded();
        }
        catch (Throwable e) {
            throw new CryptoException("P7Sign Error:" + e.getMessage(), e);
        }
    }

    public static byte[] encrypt(int alg, byte[] key, byte[] plaindata, byte[] iv) throws CryptoException {
        try {
            String strAlg = SoftCryptoImpl.getDesc(alg);
            SecretKeySpec sk = new SecretKeySpec(key, strAlg);
            Cipher c = Cipher.getInstance(strAlg, "INFOSEC");
            if (c == null) {
                throw new CryptoException("encryptError:Cipher construct fail");
            }
            byte[] edata = null;
            if (alg != RC4 && iv != null) {
                IvParameterSpec paramSpec = new IvParameterSpec(iv);
                c.init(1, (Key)sk, paramSpec);
                edata = c.doFinal(plaindata);
            } else {
                c.init(1, sk);
                edata = c.doFinal(plaindata);
            }
            return edata;
        }
        catch (CryptoException ce) {
            throw ce;
        }
        catch (Throwable e) {
            throw new CryptoException("encryptError:" + e.toString(), e);
        }
    }

    public static byte[] encryptWithRSAPubkey(PublicKey pubk, byte[] value) throws CryptoException {
        try {
            Cipher c = null;
            byte[] encKey = null;
            c = Cipher.getInstance("RSA/NONE/PKCS1Padding", "INFOSEC");
            if (c == null) {
                throw new CryptoException("encryptWithRSAPubkeyError: Cipher construct fail");
            }
            c.init(1, pubk);
            encKey = c.doFinal(value);
            return encKey;
        }
        catch (Throwable e) {
            throw new CryptoException("encryptWithRSAPubkeyError :" + e.toString(), e);
        }
    }

    public static byte[] decryptWithRSAprivatekey(PrivateKey privatekey, byte[] value) throws CryptoException {
        try {
            Cipher c = null;
            byte[] encKey = null;
            c = Cipher.getInstance("RSA/NONE/PKCS1PADDING", "INFOSEC");
            if (c == null) {
                throw new CryptoException("decryptWithRSAprivatekeyError: Cipher construct fail");
            }
            c.init(2, privatekey);
            encKey = c.doFinal(value);
            return encKey;
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoException("decryptWithRSAprivatekeyError: " + e.toString(), e);
        }
    }

    public static byte[] decrypt(int alg, byte[] key, byte[] encdata, byte[] iv) throws CryptoException {
        try {
            String strAlg = SoftCryptoImpl.getDesc(alg);
            SecretKeySpec sk = new SecretKeySpec(key, strAlg);
            byte[] endata = encdata;
            Cipher c = Cipher.getInstance(strAlg, "INFOSEC");
            if (c == null) {
                throw new CryptoException("decryptError:Cipher construct fail");
            }
            byte[] dedata = null;
            if (alg != RC4 && iv != null) {
                IvParameterSpec paramSpec = new IvParameterSpec(iv);
                c.init(2, (Key)sk, paramSpec);
                dedata = c.doFinal(endata);
            } else {
                c.init(2, sk);
                dedata = c.doFinal(endata);
            }
            return dedata;
        }
        catch (CryptoException ce) {
            throw ce;
        }
        catch (Throwable e) {
            throw new CryptoException("decryptError :" + e.toString(), e);
        }
    }

    public static byte[] hash(String strAlg, byte[] srcdata) throws CryptoException {
        try {
            MessageDigest md = MessageDigest.getInstance(strAlg);
            if (md == null) {
                throw new CryptoException("hashError:Message Digest construct fail");
            }
            ByteArrayInputStream bi = new ByteArrayInputStream(srcdata);
            BufferedInputStream in = new BufferedInputStream(bi);
            if (in == null) {
                throw new CryptoException("hashError:source data is invalid");
            }
            int theByte = 0;
            while ((theByte = in.read()) != -1) {
                md.update((byte)theByte);
            }
            in.close();
            byte[] theDigest = md.digest();
            return theDigest;
        }
        catch (CryptoException ce) {
            throw ce;
        }
        catch (Throwable e) {
            throw new CryptoException("hashError:" + e.toString(), e);
        }
    }

    private static KeyPair genrsakeypair(String alg, int keysize) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(alg, "INFOSEC");
        SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
        keyPairGen.initialize(keysize, rand);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        return keyPair;
    }

    private static void saveKeyStore(KeyStore keyStore, File fKeyStoreFile, char[] cPassword) throws Exception {
        FileOutputStream fos = null;
        fos = new FileOutputStream(fKeyStoreFile);
        try {
            keyStore.store(fos, cPassword);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (KeyStoreException ex) {
            throw ex;
        }
        catch (CertificateException ex) {
            throw ex;
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        fos.close();
    }

    public static X509Certificate generateCert(String subject, PublicKey publicKey, PrivateKey privateKey, String signatureType) throws Exception {
        X509Name dn = new X509Name(subject);
        int iValidity = 365;
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        certGen.setIssuerDN(dn);
        certGen.setNotBefore(new Date(System.currentTimeMillis()));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + (long)iValidity * 24L * 60L * 60L * 1000L));
        certGen.setSubjectDN(dn);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(signatureType.toString());
        certGen.setSerialNumber(SoftCryptoImpl.generateX509SerialNumber());
        X509Certificate cert = certGen.generateX509Certificate(privateKey);
        return cert;
    }

    private static BigInteger generateX509SerialNumber() {
        return new BigInteger(Long.toString(System.currentTimeMillis() / 1000L));
    }

    public static void importCAReplay(X509Certificate cert, String jksname, String jkspass, String alias, String aliaspass) throws CryptoException {
        try {
            KeyStore jksstore = KeyStore.getInstance("jks");
            File jksfile = new File(jksname);
            if (!jksfile.exists()) {
                throw new CryptoException("JKS File Is Not Exists");
            }
            FileInputStream finput = new FileInputStream(jksfile);
            jksstore.load(finput, jkspass.toCharArray());
            finput.close();
            Certificate certold = jksstore.getCertificate(alias);
            if (certold == null) {
                throw new CryptoException("The Alias Is Not Exists");
            }
            if (!Arrays.equals(certold.getPublicKey().getEncoded(), cert.getPublicKey().getEncoded())) {
                throw new CryptoException("The CA reply is invalid");
            }
            Certificate[] newCertChain = new Certificate[]{cert};
            Key privKey = jksstore.getKey(alias, aliaspass.toCharArray());
            jksstore.deleteEntry(alias);
            jksstore.setKeyEntry(alias, privKey, aliaspass.toCharArray(), newCertChain);
            SoftCryptoImpl.saveKeyStore(jksstore, jksfile, jkspass.toCharArray());
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new CryptoException("Import CA replay error :" + ex.toString(), ex);
        }
    }

    public static byte[] genSecretKey(int alg, int length) throws CryptoException {
        try {
            String strAlg = SoftCryptoImpl.getDesc(alg);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(strAlg, "INFOSEC");
            if (keyGenerator == null) {
                throw new CryptoException("genSecretKeyError:KeyGenerator construct fail");
            }
            keyGenerator.init(length, new SecureRandom());
            SecretKey key = keyGenerator.generateKey();
            if (key == null) {
                throw new CryptoException("genSecretKeyError:SecretKey generator fail");
            }
            return key.getEncoded();
        }
        catch (CryptoException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CryptoException("genSecretKeyError: " + e.toString(), e);
        }
    }

    public static String getDesc(int alg) throws CryptoException {
        if (alg == 100) {
            return "SHA1";
        }
        if (alg == 101) {
            return "MD5";
        }
        if (alg == 102) {
            return "MD2";
        }
        if (alg == SHA1_WITH_RSA) {
            return "SHA1withRSA";
        }
        if (alg == 300) {
            return "AES";
        }
        if (alg == RSAKeyPair) {
            return "RSA";
        }
        if (alg == RC4) {
            return "RC4";
        }
        if (alg == 501) {
            return "DESEDE";
        }
        if (alg == 301) {
            return "1.2.840.113549.3.7";
        }
        if (alg == RSA) {
            return "RSA/ECB/PKCS1Padding";
        }
        throw new CryptoException("Algorithmic " + alg + " not yet implemented.");
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        SoftCryptoImpl.hash("MD2", "11".getBytes());
    }
}

