package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.enums.loan.OwnerPaymentEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
public class OwnerPaymentVO{

    
    private Integer id;

    
    @ApiModelProperty("货主编码")
    private String ownerUserNo;

    
    @ApiModelProperty("货主名称")
    private String ownerUserName;

    
    @ApiModelProperty("联系电话")
    private String mobile;

    
    @ApiModelProperty("交易流水号（第三方）")
    private String runningWaterOpenNo;

    
    @ApiModelProperty("付款单号")
    private Long paymentNo;

    
    @ApiModelProperty("还款单号")
    private Long repaymentNo;

    @MoneyOutConvert
    @ApiModelProperty("付款金额")
    private BigDecimal paymentBalance;

    
    @ApiModelProperty("付款方")
    private String payment;

    
    @ApiModelProperty("付款账户")
    private String paymentAccount;

    
    @ApiModelProperty("收款方")
    private String payee;

    
    @ApiModelProperty("收款账户")
    private String payeeAccount;

    
    @ApiModelProperty("10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;

    @ApiModelProperty("待付款  付款中 付款成功 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerPaymentEnum.Status.getMsgByCode(status);
    }

    
    @ApiModelProperty("默认财资")
    private Integer payChannel;

    @ApiModelProperty("支付渠道名称")
    private String payChannelMsg;

    public String getPayChannelMsg(){
        return OwnerLoanRecordEnum.PayChannel.ASSET.getMsg();
    }

    
    @ApiModelProperty("操作时间")
    private String operateTime;

    
    @ApiModelProperty("操作人")
    private String operateBy;

    
    @ApiModelProperty("创建人")
    private String createBy;

    
    @ApiModelProperty("创建时间")
    private String createTime;

    
    @ApiModelProperty("修改时间")
    private String modifiedTime;
}
