package com.clx.performance.vo.pc.broker;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOrderDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @Schema(description = "货单编号", example = "12020083116861267", required = true)
    private String sourceOrderNo;

    @Schema(description = "发布货源时间", example = "2023-01-01 00:00:00", required = true)
    private String publishTime;
    @Schema(description = "最晚装货时间", example = "2023-01-01 00:00:00", required = true)
    private String extractTime;
    @Schema(description = "司机最晚到达时间", example = "2023-01-01 00:00:00", required = true)
    private String arriveTime;

    @Schema(description = "总货物数量", example = "32.12", required = true)
    private BigDecimal goodsAmount;
    @Schema(description = "货物名称", example = "原煤", required = true)
    private String goodsName;
    @Schema(description = "货物运费单价（分）", example = "3212", required = true)
    private Integer transPrice;
    @Schema(description = "货物价值（分）", example = "3212", required = true)
    private Integer goodsPrice;

    @Schema(description = "发货单位", example = "发货单位", required = true)
    private String sendCompany;
    @Schema(description = "货源所在详细地址", example = "货源所在详细地址", required = true)
    private String sendAddress;
    @Schema(description = "发货人姓名", example = "张三", required = true)
    private String sendName;
    @Schema(description = "收货人所在详细地址", example = "收货人所在详细地址", required = true)
    private String receiveAddress;
    @Schema(description = "收货单位", example = "收货单位", required = true)
    private String receiveCompany;
    @Schema(description = "收货人姓名", example = "张三", required = true)
    private String receiveName;

    @Schema(description = "发货所在省份", required = true)
    private String sendProvince;
    @Schema(description = "发货所在城市", required = true)
    private String sendCity;
    @Schema(description = "发货所在区县", required = true)
    private String sendCounty;
    @Schema(description = "发货所在乡镇", required = true)
    private String sendTown;
    @Schema(description = "发货联系人手机号", required = true)
    private String sendMobile;
    @Schema(description = "发货地址经度", required = true)
    private String loadLongitude;
    @Schema(description = "发货地址纬度", required = true)
    private String loadLatitude;
    @Schema(description = "收货人所在省", required = true)
    private String receiveProvince;
    @Schema(description = "收货人所在城市", required = true)
    private String receiveCity;
    @Schema(description = "收货人所在区县", required = true)
    private String receiveCounty;
    @Schema(description = "收货人所在乡镇", required = true)
    private String receiveTown;
    @Schema(description = "收货联系人手机号", required = true)
    private String receiveMobile;
    @Schema(description = "收货地址经度", required = true)
    private String unloadLongitude;
    @Schema(description = "收货地址纬度", required = true)
    private String unloadLatitude;

}
