package com.clx.performance.vo.pc.breakcontract.owner;

import com.clx.performance.vo.pc.OrderChildLogVO;
import com.clx.performance.vo.pc.OrderChildPoundAuditDetailVO;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;


@Schema(description = "运单表")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierOrderChildDetailVO {


    @Schema(description = "运单编号", example = "100000000")
    private String childNo;

    @Schema(description = "货单编号", example = "100000000")
    private String orderGoodsNo;

    @Schema(description = "货物名称", example = "煤")
    private String goodsName;

    @Schema(description = "运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freightPrice;

    @Schema(description = "应付运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal payableFreight;

    @Schema(description = "亏吨扣款（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossDeduction;

    @Schema(description = "实付运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal realFreight;


    @Schema(description = "损耗单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossPrice;

    @Schema(description = "订单运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal orderFreightPrice;

    @Schema(description="货物重量")
    private BigDecimal extractWeight;

    @Schema(description = "发货地址", example = "朝阳")
    private String sendAddress;

    @Schema(description = "收货地址", example = "西城")
    private String receiveAddress;

    @Schema(description = "车牌号", example = "京A12345")
    private String truckNo;

    @Schema(description = "司机姓名", example = "张三")
    private String driverName;

    @Schema(description = "司机手机号", example = "130000000")
    private String driverMobile;

    @Schema(description = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;

    @Schema(description = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;


    @Schema(description = "取消原因", example = "抢错了")
    private String cancelRemark;

    @Schema(description = "状态", example = "0")
    private Integer status;

    @Schema(description = "装车磅单图片列表")
    private List<String> loadImageList;

    @Schema(description = "卸车磅单图片列表")
    private List<String> unloadImageList;

    @Schema(description = "流程节点")
    private List<OrderChildLogVO> childLogs;

    @Schema(description = "磅单审核列表")
    private List<OrderChildPoundAuditDetailVO> poundAudits;

    @Schema(description = "完成时间", example = "2020-01-01 10:10:10")
    private String finishTime;


}