package com.clx.performance.sqlProvider.collect;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.collect.PageCollectTruckRefuelParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam;
import com.clx.performance.vo.pc.collect.CollectTruckRefuelVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class CollectTruckRefuelSqlProvider {

    public String pageRefuel(@Param("page") Page<CollectTruckRefuelVO> page, @Param("param") PageCollectTruckRefuelParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, child_no as childNo, " +
                    " send_address as sendAddress, receive_address as receiveAddress, " +
                    " load_image as loadImage, load_oil as loadOil, " +
                    " unload_image as unloadImage, unload_oil as unloadOil, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_truck_refuel ");
            WHERE("user_no = #{param.userNo} ");

            ORDER_BY("report_time desc");
        }}.toString();
    }

    public String carrierPageRefuel(@Param("page") Page<CollectTruckRefuelVO> page, @Param("param") CarrierPageCollectTruckRefuelParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, child_no as childNo, " +
                    " send_address_id, send_address, receive_address_id, receive_address, " +
                    " load_image as loadImage, load_oil as loadOil, " +
                    " unload_image as unloadImage, unload_oil as unloadOil, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_truck_refuel ");

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address like CONCAT(#{param.sendAddress},'%')");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address like CONCAT(#{param.receiveAddress},'%')");}
            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}
            if (StringUtils.isNotBlank(param.getTruckNo())) {WHERE("truck_no like CONCAT('%', #{param.truckNo}, '%')");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }



}
