package com.clx.performance.dao.export;

import com.clx.performance.mapper.export.ExportTemplateMapper;
import com.clx.performance.model.export.ExportTemplate;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;

public interface ExportTemplateDao extends BaseDao<ExportTemplateMapper, ExportTemplate, Integer> {

    List<ExportTemplate> listUserFunctionTemplate(String functionCode);

    Optional<ExportTemplate> getUserFunctionTemplateByName(String functionCode, String name);

    List<ExportTemplate> listUserFunctionsTemplate(List<String> functionCodes);

    Optional<ExportTemplate> getById(Integer id);

    void saveTemplate(ExportTemplate template);

    void deleteTemplate(Integer id);

    void updateTemplateName(Integer id, String name);

    void updateTemplateNotDefault(String functionCode);

    void updateTemplateDefault(Integer templateId);

    long countUserFunctionTemplate(String functionCode);
}
