package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerDetailParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerDetailService;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletResponse;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract")
@Validated
@Tag(name = "承运端-违约计费（货主）")
@AllArgsConstructor
public class CarrierBreakContractSettlementOwnerDetailController {

    private final BreakContractSettlementOwnerDetailService breakContractSettlementOwnerDetailService;


    @Operation(summary = "列表",description = "<br>By:李瑞新")
    @PostMapping("/pageCarrierBreakContractSettlementOwnerDetailList")
    @UnitCovert(param = false)
    public Result<PageData<PageCarrierBreakContractSettlementOwnerDetailVO>> pageCarrierBreakContractSettlementOwnerDetailList(@RequestBody PageCarrierBreakContractSettlementOwnerDetailParam param) {
        IPage<PageCarrierBreakContractSettlementOwnerDetailVO> page = breakContractSettlementOwnerDetailService.pageCarrierBreakContractSettlementOwnerDetailList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "导出")
    @PostMapping("/exportCarrierBreakContractSettlementOwnerDetailList")
    public Result exportCarrierBreakContractSettlementOwnerDetailList(@RequestBody  PageCarrierBreakContractSettlementOwnerDetailParam param, HttpServletResponse response) throws Exception {

        SXSSFWorkbook workbook = breakContractSettlementOwnerDetailService.exportCarrierBreakContractSettlementOwnerDetailList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }

}
