package com.clx.performance.controller.app;

import com.clx.performance.param.app.collect.*;
import com.clx.performance.service.collect.CollectTruckService;
import com.clx.performance.vo.app.collect.AppCollectTruckVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotBlank;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/truck")
@Validated
@Tag(name = "APP-车辆上报")
@AllArgsConstructor
public class AppDriverCollectTruckController {

    private final CollectTruckService collectTruckService;

    @Operation(summary = "更新卸车方式", description = "<br>By:艾庆国")
    @PostMapping("/updateUnloadType")
    public Result<Void> updateUnloadType(@RequestBody @Validated CollectTruckUnloadTypeUpdateParam param) {
        collectTruckService.updateUnloadType(param);

        return Result.ok();
    }

    @Operation(summary = "更新车贷情况", description = "<br>By:艾庆国")
    @PostMapping("/updateAutoLoanStatus")
    public Result<Void> updateAutoLoanStatus(@RequestBody @Validated CollectAutoLoanStatusUpdateParam param) {
        collectTruckService.updateAutoLoanStatus(param);

        return Result.ok();
    }

    @Operation(summary = "更新车辆停放位置", description = "<br>By:艾庆国")
    @PostMapping("/updateParkAddress")
    public Result<Void> updateParkAddress(@RequestBody @Validated CollectTruckReportParkAddressUpdateParam param) {
        collectTruckService.updateParkAddress(param);

        return Result.ok();
    }

    @Operation(summary = "更新拉运方式", description = "<br>By:艾庆国")
    @PostMapping("/updateOverTonnageType")
    public Result<Void> updateOverTonnageType(@RequestBody @Validated CollectTruckReportOverTonnageTypeUpdateParam param) {
        collectTruckService.updateOverTonnageType(param);

        return Result.ok();
    }

    @Operation(summary = "更新接受距常驻地最远距离", description = "<br>By:艾庆国")
    @PostMapping("/updateUsualPlaceDistanceMax")
    public Result<Void> updateDistanceUsualPlaceMax(@RequestBody @Validated CollectTruckReportDistanceUsualPlaceMaxUpdateParam param) {
        collectTruckService.updateDistanceUsualPlaceMax(param);

        return Result.ok();
    }
    @Operation(summary = "更新单次任务接受最远距离", description = "<br>By:艾庆国")
    @PostMapping("/updateLineDistanceMax")
    public Result<Void> updateDistanceLineMax(@RequestBody @Validated CollectTruckReportDistanceLineMaxUpdateParam param) {
        collectTruckService.updateDistanceLineMax(param);

        return Result.ok();
    }

    @Operation(summary = "更新接受距货源地最远距离", description = "<br>By:艾庆国")
    @PostMapping("/updateSendAddressDistanceMax")
    public Result<Void> updateDistanceSendAddressMax(@RequestBody @Validated CollectTruckReportDistanceSendAddressMaxUpdateParam param) {
        collectTruckService.updateDistanceSendAddressMax(param);

        return Result.ok();
    }

    @Operation(summary = "更新拉运货物意愿", description = "<br>By:艾庆国")
    @PostMapping("/updateGoodsType")
    public Result<Void> updateGoodsType(@RequestBody @Validated CollectTruckReportGoodsTypeUpdateParam param) {
        collectTruckService.updateGoodsType(param);

        return Result.ok();
    }

    @Operation(summary = "查询车辆详情", description = "<br>By:艾庆国")
    @GetMapping("/getReportInfo")
    public Result<AppCollectTruckVO> getReportInfo(@Validated @NotBlank(message = "车牌不能为空") String truckNo) {

        return Result.ok(collectTruckService.getReportInfo(truckNo));

    }

}
