package com.clx.performance.vo.pc.collect;

import com.alibaba.fastjson.JSON;
import com.clx.performance.enums.collect.CollectLineReportEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
* @Author: aiqinguo
* @Description: 线路信息上报
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@Schema(description = "线路信息上报")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectLineReportVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "用户编号", example = "")
    private Long userNo;
    @Schema(description = "用户姓名", example = "")
    private String name;
    @Schema(description = "手机号码", example = "")
    private String mobile;
    @Schema(description = "车牌号", example = "")
    private String truckNo;
    @Schema(description = "运单编号", example = "")
    private String childNo;
    @Schema(description = "货单单编号", example = "")
    private String orderGoodsNo;

    @Schema(description = "发货地址id", example = "")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "")
    private String receiveAddress;

    @Schema(description = "类型：1 发货地 2 目的地", example = "")
    private Integer type;
    @Schema(description = "上报类型（1~4异常上报）：1:无法到达货源地 2:无法装货 3：无法到达目的地  4：装卸车时间过长    6：没有接单 7：货源地情况 8:其它上报 9：煤炭质量上报", example = "")
    private Integer reportType;
    @Schema(description = "上报类型（1~4异常上报）：1:无法到达货源地 2:无法装货 3：无法到达目的地  4：装卸车时间过长    6：没有接单 7：货源地情况 8:其它上报 9：煤炭质量上报", example = "")
    private String reportTypeMsg;
    public String getReportTypeMsg() {
        return CollectLineReportEnum.ReportType.getByCode(reportType).get().getMsg();
    }

    @Schema(description = "拉运状态 1: 正常 2：异常", example = "")
    private Integer reportStatus;
    @Schema(description = "拉运状态 1: 正常 2：异常", example = "")
    private String reportStatusMsg;
    public String getReportStatusMsg() {
        return Objects.equals(CollectLineReportEnum.ReportType.SEND_ADDRESS.getCode(), reportType)?
                CollectLineReportEnum.CoalStatus.getByCode(reportStatus).get().getMsg() :
                CollectLineReportEnum.ReportStatus.getByCode(reportStatus).get().getMsg();
    }

    @Schema(description = "状态描述", example = "")
    private String remark;
    @Schema(description = "上报图片", example = "", hidden = true)
    private String image;
    @Schema(description = "上报图片")
    private List<String> imageList;
    public List<String> getImageList() {
        return StringUtils.isEmpty(image)? new ArrayList<>() : JSON.parseArray(image, String.class);
    }

    @Schema(description = "上报时间", example = "")
    private String reportTime;
    @Schema(description = "审核状态：0待审核 1已审核", example = "")
    private Integer auditStatus;
    @Schema(description = "审核状态：0待审核 1已审核", example = "")
    private String auditStatusMsg;
    public String getAuditStatusMsg() {
        return CollectLineReportEnum.AuditStatus.getByCode(auditStatus).get().getMsg();
    }

    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}