package com.clx.performance.vo.pc.broker;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class TransportParam {

    @Schema(description = "用户编号", required = true)
    @NotNull(message = "用户编号不能为空")
    private String userCode;

    @Schema(description = "网络货运平台编码", example = "123", required = true)
    @NotBlank(message = "网络货运平台编码不能为空")
    private String transportPlatformCode;

    @Schema(description = "货主手机号（货主账号）", example = "", required = true)
    @NotBlank(message = "货主手机号（货主账号）不能为空")
    private String ownerMobile;

    @Schema(description = "货主用户名字", example = "", required = true)
    private String ownerName;

    @Schema(description = "运单编号", required = true)
    @NotBlank(message = "运单编号不能为空")
    private String orderCode;

    @Schema(description = "货单", required = true)
    @NotNull(message = "货单不能为空")
    private OpenOrderDTO order;

    @Schema(description = "图片", required = true)
    @NotEmpty(message = "运单图片不能为空")
    private List<OpenOrderChildImageDTO> orderChildImage;

    @Schema(description = "司机", required = true)
    @NotNull(message = "司机不能为空")
    private OpenOrderChildDriverDTO orderChildDriver;

    @Schema(description = "车主", required = true)
    @NotNull(message = "车主不能为空")
    private OpenOrderChildTruckOwnerDTO orderChildTruckOwner;

    @Schema(description = "车辆", required = true)
    @NotNull(message = "车辆不能为空")
    private OpenOrderChildTruckDTO orderChildTruck;

    @Schema(description = "运单", required = true)
    @NotNull(message = "运单不能为空")
    private OpenOrderChildDTO orderChild;

}
