package com.clx.performance.vo.feign;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;

/**
 * @ClassName OrderExtractWeightVO
 * @Description
 * @Author kavin
 * @Date 2024/8/5 11:54
 * @Version 1.0
 */

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OrderExtractWeightVO {

    @Schema(description="用车需求： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;

    @Schema(description = "拉运吨数")
    private BigDecimal transportWeight;


    @Schema(description="可提取吨数")
    private BigDecimal canExtractWeight;


    @Schema(description="平台承运吨数")
    private BigDecimal platformCarryWeight;


    @Schema(description="自有承运吨数")
    private BigDecimal ownCarryWeight;


    @Schema(description="平台可提取吨数")
    private BigDecimal platCanExtractWeight;

    @Schema(description="自有可提取吨数")
    private BigDecimal ownCanExtractWeight;


}
